/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.keyvalue;

import jakarta.data.exceptions.NonUniqueResultException;
import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jnosql.communication.Params;
import org.eclipse.jnosql.communication.QueryException;
import org.eclipse.jnosql.communication.Value;
import org.eclipse.jnosql.communication.keyvalue.BucketManager;
import org.eclipse.jnosql.communication.keyvalue.KeyValueEntity;
import org.eclipse.jnosql.communication.keyvalue.KeyValuePreparedStatement;

final class DefaultKeyValuePreparedStatement
implements KeyValuePreparedStatement {
    private final List<Value> keys;
    private final PreparedStatementType type;
    private final BucketManager manager;
    private final List<String> paramsLeft;
    private final Params params;
    private final Duration ttl;
    private final String query;
    private final Value key;
    private final Value value;

    DefaultKeyValuePreparedStatement(Value key, Value value, List<Value> keys, PreparedStatementType type, BucketManager manager, Params params, Duration ttl, String query) {
        this.key = key;
        this.value = value;
        this.keys = keys;
        this.type = type;
        this.manager = manager;
        this.params = params;
        this.paramsLeft = params.getParametersNames();
        this.ttl = ttl;
        this.query = query;
    }

    @Override
    public KeyValuePreparedStatement bind(String name, Object value) {
        Objects.requireNonNull(name, "name is required");
        Objects.requireNonNull(value, "value is required");
        this.paramsLeft.remove(name);
        this.params.bind(name, value);
        return this;
    }

    @Override
    public Stream<Value> result() {
        if (!this.paramsLeft.isEmpty()) {
            throw new QueryException("Check all the parameters before execute the query, params left: " + this.paramsLeft);
        }
        switch (this.type) {
            case GET: {
                return this.keys.stream().map(Value::get).map(this.manager::get).filter(Optional::isPresent).map(Optional::get);
            }
            case DEL: {
                this.manager.delete(this.keys.stream().map(Value::get).collect(Collectors.toList()));
                return Stream.empty();
            }
            case PUT: {
                KeyValueEntity entity = KeyValueEntity.of(this.key.get(), this.value.get());
                if (Objects.isNull(this.ttl)) {
                    this.manager.put(entity);
                } else {
                    this.manager.put(entity, this.ttl);
                }
                return Stream.empty();
            }
        }
        throw new UnsupportedOperationException("there is not support to operation type: " + this.type);
    }

    @Override
    public Optional<Value> singleResult() {
        Stream<Value> entities = this.result();
        Iterator iterator = entities.iterator();
        if (!iterator.hasNext()) {
            return Optional.empty();
        }
        Value next = (Value)iterator.next();
        if (!iterator.hasNext()) {
            return Optional.of(next);
        }
        throw new NonUniqueResultException("The select returns more than one entity, select: " + this.query);
    }

    static KeyValuePreparedStatement get(List<Value> keys, BucketManager manager, Params params, String query) {
        return new DefaultKeyValuePreparedStatement(null, null, keys, PreparedStatementType.GET, manager, params, null, query);
    }

    static KeyValuePreparedStatement put(Value key, Value value, BucketManager manager, Params params, Duration ttl, String query) {
        return new DefaultKeyValuePreparedStatement(key, value, null, PreparedStatementType.PUT, manager, params, ttl, query);
    }

    static KeyValuePreparedStatement del(List<Value> keys, BucketManager manager, Params params, String query) {
        return new DefaultKeyValuePreparedStatement(null, null, keys, PreparedStatementType.DEL, manager, params, null, query);
    }

    static enum PreparedStatementType {
        GET,
        PUT,
        DEL;

    }
}

