/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.keyvalue;

import java.util.Objects;
import java.util.ServiceLoader;
import java.util.function.Function;
import org.eclipse.jnosql.communication.CommunicationException;
import org.eclipse.jnosql.communication.Settings;
import org.eclipse.jnosql.communication.keyvalue.BucketManagerFactory;

public interface KeyValueConfiguration
extends Function<Settings, BucketManagerFactory> {
    public static <T extends KeyValueConfiguration> T getConfiguration() {
        return (T)ServiceLoader.load(KeyValueConfiguration.class).stream().map(ServiceLoader.Provider::get).findFirst().orElseThrow(() -> new CommunicationException("No KeyValueConfiguration implementation found!"));
    }

    public static <T extends KeyValueConfiguration> T getConfiguration(Class<T> type) {
        Objects.requireNonNull(type, "service is required");
        return (T)ServiceLoader.load(KeyValueConfiguration.class).stream().map(ServiceLoader.Provider::get).filter(type::isInstance).findFirst().orElseThrow(() -> new CommunicationException("No KeyValueConfiguration implementation found!"));
    }
}

