/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.query;

import jakarta.nosql.query.Condition;
import jakarta.nosql.query.JSONQueryValue;
import jakarta.nosql.query.Operator;
import jakarta.nosql.query.QueryValue;
import jakarta.nosql.query.UpdateQuery;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.jnosql.communication.query.AbstractSupplier;
import org.eclipse.jnosql.communication.query.DefaultCondition;
import org.eclipse.jnosql.communication.query.DefaultJSONQueryValue;
import org.eclipse.jnosql.communication.query.DefaultUpdateQuery;
import org.eclipse.jnosql.communication.query.QueryParser;
import org.eclipse.jnosql.communication.query.ValueConverter;

public final class AntlrUpdateQueryProvider
extends AbstractSupplier
implements UpdateQuery.UpdateQueryProvider {
    private String entity;
    private List<Condition> conditions = Collections.emptyList();
    private JSONQueryValue value;

    @Override
    Function<QueryParser, ParseTree> getParserTree() {
        return QueryParser::update;
    }

    @Override
    public void exitEntity(QueryParser.EntityContext ctx) {
        this.entity = ctx.getText();
    }

    @Override
    public void exitChanges(QueryParser.ChangesContext ctx) {
        this.conditions = ctx.change().stream().map(this::getCondition).collect(Collectors.toList());
    }

    @Override
    public void enterJson(QueryParser.JsonContext ctx) {
        this.value = DefaultJSONQueryValue.of(ctx);
    }

    private Condition getCondition(QueryParser.ChangeContext changeContext) {
        String name = changeContext.name().getText();
        QueryValue<?> queryValue = ValueConverter.get(changeContext.value());
        return new DefaultCondition(name, Operator.EQUALS, queryValue);
    }

    public UpdateQuery apply(String query) {
        this.runQuery(query);
        return new DefaultUpdateQuery(this.entity, this.conditions, this.value);
    }
}

