/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.query;

import jakarta.nosql.QueryException;
import jakarta.nosql.query.Function;
import jakarta.nosql.query.FunctionQueryValue;
import jakarta.nosql.query.QueryValue;
import java.util.Objects;
import org.eclipse.jnosql.communication.query.DefaultFunction;
import org.eclipse.jnosql.communication.query.Elements;
import org.eclipse.jnosql.communication.query.QueryParser;

final class DefaultFunctionQueryValue
implements FunctionQueryValue {
    private final Function function;

    private DefaultFunctionQueryValue(Function function) {
        this.function = function;
    }

    public Function get() {
        return this.function;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultFunctionQueryValue)) {
            return false;
        }
        DefaultFunctionQueryValue that = (DefaultFunctionQueryValue)o;
        return Objects.equals(this.function, that.function);
    }

    public int hashCode() {
        return Objects.hashCode(this.function);
    }

    public String toString() {
        return this.function.toString();
    }

    static FunctionQueryValue of(QueryParser.FunctionContext context) {
        if (Objects.nonNull((Object)context.convert())) {
            return DefaultFunctionQueryValue.getConverter(context);
        }
        throw new UnsupportedOperationException("There is not support to this function yet");
    }

    private static FunctionQueryValue getConverter(QueryParser.FunctionContext context) {
        QueryParser.ConvertContext converter = context.convert();
        QueryValue<?> value = Elements.getElement(converter.element());
        String text = converter.name().getText();
        try {
            Object[] params = new Object[]{value, Class.forName(text)};
            Function function1 = DefaultFunction.of("convert", params);
            return new DefaultFunctionQueryValue(function1);
        }
        catch (ClassNotFoundException e) {
            throw new QueryException("Class does not found the converter function argument: " + text, (Throwable)e);
        }
    }
}

