/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.query;

import jakarta.nosql.query.Condition;
import jakarta.nosql.query.InsertQuery;
import jakarta.nosql.query.JSONQueryValue;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

final class DefaultInsertQuery
implements InsertQuery {
    private final String entity;
    private final Duration duration;
    private final List<Condition> conditions;
    private final JSONQueryValue value;

    DefaultInsertQuery(String entity, Duration duration, List<Condition> conditions, JSONQueryValue value) {
        this.entity = entity;
        this.duration = duration;
        this.conditions = conditions;
        this.value = value;
    }

    public String getEntity() {
        return this.entity;
    }

    public Optional<Duration> getTtl() {
        return Optional.ofNullable(this.duration);
    }

    public List<Condition> getConditions() {
        return Collections.unmodifiableList(this.conditions);
    }

    public Optional<JSONQueryValue> getValue() {
        return Optional.ofNullable(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultInsertQuery)) {
            return false;
        }
        DefaultInsertQuery that = (DefaultInsertQuery)o;
        return Objects.equals(this.entity, that.entity) && Objects.equals(this.duration, that.duration) && Objects.equals(this.conditions, that.conditions);
    }

    public int hashCode() {
        return Objects.hash(this.entity, this.duration, this.conditions);
    }

    public String toString() {
        if (this.conditions.isEmpty() && this.value != null) {
            return "insert " + this.entity + " " + this.value + " " + this.getTtl().map(Duration::toString).orElse("");
        }
        return "insert " + this.entity + " (" + this.conditions + ") " + this.getTtl().map(Duration::toString).orElse("");
    }
}

