/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.query;

import jakarta.nosql.query.PutQuery;
import jakarta.nosql.query.QueryValue;
import java.time.Duration;
import java.util.Optional;

final class DefaultPutQuery
implements PutQuery {
    private final QueryValue<?> key;
    private final QueryValue<?> value;
    private final Duration ttl;

    DefaultPutQuery(QueryValue<?> key, QueryValue<?> value, Duration ttl) {
        this.key = key;
        this.value = value;
        this.ttl = ttl;
    }

    public QueryValue<?> getKey() {
        return this.key;
    }

    public QueryValue<?> getValue() {
        return this.value;
    }

    public Optional<Duration> getTtl() {
        return Optional.ofNullable(this.ttl);
    }

    public String toString() {
        StringBuilder put = new StringBuilder();
        put.append("put {").append(this.key).append(" , ").append(this.value);
        if (this.ttl != null) {
            put.append(",").append(this.ttl);
        }
        put.append("}");
        return put.toString();
    }
}

