/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.query;

import jakarta.nosql.query.Condition;
import jakarta.nosql.query.JSONQueryValue;
import jakarta.nosql.query.UpdateQuery;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

final class DefaultUpdateQuery
implements UpdateQuery {
    private final String entity;
    private final List<Condition> conditions;
    private final JSONQueryValue value;

    DefaultUpdateQuery(String entity, List<Condition> conditions, JSONQueryValue value) {
        this.entity = entity;
        this.conditions = conditions;
        this.value = value;
    }

    public String getEntity() {
        return this.entity;
    }

    public List<Condition> getConditions() {
        return Collections.unmodifiableList(this.conditions);
    }

    public Optional<JSONQueryValue> getValue() {
        return Optional.ofNullable(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultUpdateQuery)) {
            return false;
        }
        DefaultUpdateQuery that = (DefaultUpdateQuery)o;
        return Objects.equals(this.entity, that.entity) && Objects.equals(this.conditions, that.conditions);
    }

    public int hashCode() {
        return Objects.hash(this.entity, this.conditions);
    }

    public String toString() {
        if (this.conditions.isEmpty() && this.value != null) {
            return "update " + this.entity + " " + this.value;
        }
        return "update " + this.entity + " (" + this.conditions + ") ";
    }
}

