/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.query;

import jakarta.nosql.QueryException;
import jakarta.nosql.query.QueryValue;
import java.util.Objects;
import org.eclipse.jnosql.communication.query.DefaultArrayValue;
import org.eclipse.jnosql.communication.query.DefaultFunctionQueryValue;
import org.eclipse.jnosql.communication.query.DefaultJSONQueryValue;
import org.eclipse.jnosql.communication.query.DefaultNumberQueryValue;
import org.eclipse.jnosql.communication.query.DefaultParamQueryValue;
import org.eclipse.jnosql.communication.query.DefaultStringQueryValue;
import org.eclipse.jnosql.communication.query.Elements;
import org.eclipse.jnosql.communication.query.QueryParser;

final class ValueConverter {
    private static final String MESSAGE = "There is an error when trying to convert the value";

    private ValueConverter() {
    }

    static QueryValue<?> get(QueryParser.ValueContext context) {
        if (Objects.nonNull((Object)context.number())) {
            return DefaultNumberQueryValue.of(context.number());
        }
        if (Objects.nonNull((Object)context.string())) {
            return DefaultStringQueryValue.of(context.string());
        }
        if (Objects.nonNull((Object)context.json())) {
            return DefaultJSONQueryValue.of(context.json());
        }
        if (Objects.nonNull((Object)context.parameter())) {
            return DefaultParamQueryValue.of(context.parameter());
        }
        if (Objects.nonNull((Object)context.function())) {
            return DefaultFunctionQueryValue.of(context.function());
        }
        if (Objects.nonNull((Object)context.array())) {
            QueryValue[] elements = (QueryValue[])context.array().element().stream().map(Elements::getElement).toArray(QueryValue[]::new);
            return DefaultArrayValue.of(elements);
        }
        throw new QueryException(MESSAGE);
    }
}

