/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.query.cache;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.function.Function;

final class CacheQuery<V> {
    private final Map<String, V> store = Collections.synchronizedMap(new WeakHashMap());
    private final Function<String, V> supplier;

    private CacheQuery(Function<String, V> supplier) {
        this.supplier = supplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(String key) {
        V value = this.store.get(key);
        if (Objects.isNull(value)) {
            CacheQuery cacheQuery = this;
            synchronized (cacheQuery) {
                value = this.supplier.apply(key);
                this.put(key, value);
            }
        }
        return value;
    }

    public int size() {
        return this.store.size();
    }

    private V put(String key, V value) {
        return this.store.put(key, value);
    }

    public String toString() {
        return "CacheQuery{store=" + this.store + "}";
    }

    public static <V> CacheQuery<V> of(Function<String, V> supplier) {
        return new CacheQuery<V>(supplier);
    }
}

