/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.query.method;

import jakarta.nosql.query.ArrayQueryValue;
import jakarta.nosql.query.Condition;
import jakarta.nosql.query.ConditionQueryValue;
import jakarta.nosql.query.Operator;
import jakarta.nosql.query.QueryValue;
import jakarta.nosql.query.Where;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.eclipse.jnosql.communication.query.QueryErrorListener;
import org.eclipse.jnosql.communication.query.method.MethodArrayValue;
import org.eclipse.jnosql.communication.query.method.MethodBaseListener;
import org.eclipse.jnosql.communication.query.method.MethodCondition;
import org.eclipse.jnosql.communication.query.method.MethodConditionValue;
import org.eclipse.jnosql.communication.query.method.MethodLexer;
import org.eclipse.jnosql.communication.query.method.MethodParamQueryValue;
import org.eclipse.jnosql.communication.query.method.MethodParser;
import org.eclipse.jnosql.communication.query.method.MethodWhere;

abstract class AbstractMethodQueryProvider
extends MethodBaseListener {
    private static final String SUB_ENTITY_FLAG = "_";
    protected Where where;
    protected Condition condition;
    protected boolean and = true;

    AbstractMethodQueryProvider() {
    }

    protected void runQuery(String query) {
        CodePointCharStream stream = CharStreams.fromString((String)query);
        MethodLexer lexer = new MethodLexer((CharStream)stream);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        MethodParser parser = new MethodParser((TokenStream)tokens);
        lexer.removeErrorListeners();
        parser.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)QueryErrorListener.INSTANCE);
        parser.addErrorListener((ANTLRErrorListener)QueryErrorListener.INSTANCE);
        ParseTree tree = this.getParserTree().apply(parser);
        ParseTreeWalker walker = new ParseTreeWalker();
        walker.walk((ParseTreeListener)this, tree);
        if (Objects.nonNull(this.condition)) {
            this.where = new MethodWhere(this.condition);
        }
    }

    abstract Function<MethodParser, ParseTree> getParserTree();

    @Override
    public void exitEq(MethodParser.EqContext ctx) {
        Operator operator = Operator.EQUALS;
        boolean hasNot = Objects.nonNull((Object)ctx.not());
        String variable = this.getVariable(ctx.variable());
        this.appendCondition(hasNot, variable, operator);
    }

    @Override
    public void exitGt(MethodParser.GtContext ctx) {
        boolean hasNot = Objects.nonNull((Object)ctx.not());
        String variable = this.getVariable(ctx.variable());
        Operator operator = Operator.GREATER_THAN;
        this.appendCondition(hasNot, variable, operator);
    }

    @Override
    public void exitGte(MethodParser.GteContext ctx) {
        boolean hasNot = Objects.nonNull((Object)ctx.not());
        String variable = this.getVariable(ctx.variable());
        Operator operator = Operator.GREATER_EQUALS_THAN;
        this.appendCondition(hasNot, variable, operator);
    }

    @Override
    public void exitLt(MethodParser.LtContext ctx) {
        boolean hasNot = Objects.nonNull((Object)ctx.not());
        String variable = this.getVariable(ctx.variable());
        Operator operator = Operator.LESSER_THAN;
        this.appendCondition(hasNot, variable, operator);
    }

    @Override
    public void exitLte(MethodParser.LteContext ctx) {
        boolean hasNot = Objects.nonNull((Object)ctx.not());
        String variable = this.getVariable(ctx.variable());
        Operator operator = Operator.LESSER_EQUALS_THAN;
        this.appendCondition(hasNot, variable, operator);
    }

    @Override
    public void exitLike(MethodParser.LikeContext ctx) {
        boolean hasNot = Objects.nonNull((Object)ctx.not());
        String variable = this.getVariable(ctx.variable());
        Operator operator = Operator.LIKE;
        this.appendCondition(hasNot, variable, operator);
    }

    @Override
    public void exitIn(MethodParser.InContext ctx) {
        boolean hasNot = Objects.nonNull((Object)ctx.not());
        String variable = this.getVariable(ctx.variable());
        Operator operator = Operator.IN;
        this.appendCondition(hasNot, variable, operator);
    }

    @Override
    public void exitBetween(MethodParser.BetweenContext ctx) {
        boolean hasNot = Objects.nonNull((Object)ctx.not());
        String variable = this.getVariable(ctx.variable());
        Operator operator = Operator.BETWEEN;
        ArrayQueryValue value = MethodArrayValue.of(variable);
        this.checkCondition(new MethodCondition(variable, operator, (QueryValue<?>)value), hasNot);
    }

    @Override
    public void exitAnd(MethodParser.AndContext ctx) {
        this.and = true;
    }

    @Override
    public void exitOr(MethodParser.OrContext ctx) {
        this.and = false;
    }

    private void appendCondition(boolean hasNot, String variable, Operator operator) {
        MethodParamQueryValue queryValue = new MethodParamQueryValue(variable);
        this.checkCondition(new MethodCondition(variable, operator, (QueryValue<?>)queryValue), hasNot);
    }

    private void checkCondition(Condition condition, boolean hasNot) {
        Condition newCondition = this.checkNotCondition(condition, hasNot);
        if (Objects.isNull(this.condition)) {
            this.condition = newCondition;
            return;
        }
        if (this.and) {
            this.appendCondition(Operator.AND, newCondition);
        } else {
            this.appendCondition(Operator.OR, newCondition);
        }
    }

    private String getVariable(MethodParser.VariableContext ctx) {
        return this.getFormatField(ctx.getText());
    }

    protected String getFormatField(String text) {
        if (text.contains(SUB_ENTITY_FLAG)) {
            return Stream.of(text.split(SUB_ENTITY_FLAG)).map(this::formatField).collect(Collectors.joining("."));
        }
        return this.formatField(text);
    }

    private String formatField(String text) {
        String lowerCase = String.valueOf(text.charAt(0)).toLowerCase(Locale.US);
        return lowerCase.concat(text.substring(1));
    }

    private boolean isAppendable(Condition condition) {
        return Operator.AND.equals((Object)condition.getOperator()) || Operator.OR.equals((Object)condition.getOperator());
    }

    private boolean isNotAppendable() {
        return !this.isAppendable(this.condition);
    }

    private Condition checkNotCondition(Condition condition, boolean hasNot) {
        if (hasNot) {
            ConditionQueryValue conditions = MethodConditionValue.of(Collections.singletonList(condition));
            return new MethodCondition("_NOT", Operator.NOT, (QueryValue<?>)conditions);
        }
        return condition;
    }

    private void appendCondition(Operator operator, Condition newCondition) {
        if (operator.equals((Object)this.condition.getOperator())) {
            ConditionQueryValue conditionValue = (ConditionQueryValue)ConditionQueryValue.class.cast(this.condition.getValue());
            ArrayList<Condition> conditions = new ArrayList<Condition>((Collection)conditionValue.get());
            conditions.add(newCondition);
            this.condition = new MethodCondition(SUB_ENTITY_FLAG + operator.name(), operator, (QueryValue<?>)MethodConditionValue.of(conditions));
        } else if (this.isNotAppendable()) {
            List<Condition> conditions = Arrays.asList(this.condition, newCondition);
            this.condition = new MethodCondition(SUB_ENTITY_FLAG + operator.name(), operator, (QueryValue<?>)MethodConditionValue.of(conditions));
        } else {
            List conditions = (List)((ConditionQueryValue)ConditionQueryValue.class.cast(this.condition.getValue())).get();
            Condition lastCondition = (Condition)conditions.get(conditions.size() - 1);
            if (this.isAppendable(lastCondition) && operator.equals((Object)lastCondition.getOperator())) {
                ArrayList<Condition> lastConditions = new ArrayList<Condition>((Collection)((ConditionQueryValue)ConditionQueryValue.class.cast(lastCondition.getValue())).get());
                lastConditions.add(newCondition);
                MethodCondition newAppendable = new MethodCondition(SUB_ENTITY_FLAG + operator.name(), operator, (QueryValue<?>)MethodConditionValue.of(lastConditions));
                ArrayList<Condition> newConditions = new ArrayList<Condition>(conditions.subList(0, conditions.size() - 1));
                newConditions.add(newAppendable);
                this.condition = new MethodCondition(this.condition.getName(), this.condition.getOperator(), (QueryValue<?>)MethodConditionValue.of(newConditions));
            } else {
                MethodCondition newAppendable = new MethodCondition(SUB_ENTITY_FLAG + operator.name(), operator, (QueryValue<?>)MethodConditionValue.of(Collections.singletonList(newCondition)));
                ArrayList<Condition> newConditions = new ArrayList<Condition>(conditions);
                newConditions.add(newAppendable);
                this.condition = new MethodCondition(this.condition.getName(), this.condition.getOperator(), (QueryValue<?>)MethodConditionValue.of(newConditions));
            }
        }
    }
}

