/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.query;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Objects;
import org.eclipse.jnosql.communication.query.QueryValue;
import org.eclipse.jnosql.communication.query.ValueType;
import org.eclipse.jnosql.query.grammar.QueryParser;

public final class JSONQueryValue
implements QueryValue<JsonObject> {
    private final JsonObject value;

    JSONQueryValue(JsonObject value) {
        this.value = value;
    }

    @Override
    public JsonObject get() {
        return this.value;
    }

    @Override
    public ValueType type() {
        return ValueType.JSON;
    }

    public static JSONQueryValue of(QueryParser.JsonContext context) {
        try (JsonReader jsonReader = Json.createReader((Reader)new StringReader(context.getText()));){
            JSONQueryValue jSONQueryValue = new JSONQueryValue(jsonReader.readObject());
            return jSONQueryValue;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JSONQueryValue that = (JSONQueryValue)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }

    public String toString() {
        return "JSONQueryValue{value=" + this.value + "}";
    }
}

