/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.query;

import java.time.Duration;
import java.util.function.Function;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.jnosql.communication.query.AbstractSupplier;
import org.eclipse.jnosql.communication.query.Durations;
import org.eclipse.jnosql.communication.query.PutQuery;
import org.eclipse.jnosql.communication.query.QueryValue;
import org.eclipse.jnosql.communication.query.ValueConverter;
import org.eclipse.jnosql.query.grammar.QueryParser;

public final class PutQueryConverter
extends AbstractSupplier
implements Function<String, PutQuery> {
    private QueryValue<?> key;
    private QueryValue<?> value;
    private Duration ttl;

    @Override
    public void exitKey(QueryParser.KeyContext ctx) {
        this.key = ValueConverter.get(ctx.value());
    }

    @Override
    public void exitValue(QueryParser.ValueContext ctx) {
        this.value = ValueConverter.get(ctx);
    }

    @Override
    public void exitTtl(QueryParser.TtlContext ctx) {
        this.ttl = Durations.get(ctx);
    }

    @Override
    Function<QueryParser, ParseTree> getParserTree() {
        return QueryParser::put;
    }

    @Override
    public PutQuery apply(String query) {
        this.runQuery(query);
        return new PutQuery(this.key, this.value, this.ttl);
    }
}

