/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.query;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jnosql.communication.query.DefaultQueryCondition;
import org.eclipse.jnosql.communication.query.JSONQueryValue;
import org.eclipse.jnosql.communication.query.Query;
import org.eclipse.jnosql.communication.query.QueryCondition;
import org.eclipse.jnosql.communication.query.UpdateQueryConverter;

public final class UpdateQuery
implements Query {
    private final String entity;
    private final List<DefaultQueryCondition> conditions;
    private final JSONQueryValue value;

    UpdateQuery(String entity, List<DefaultQueryCondition> conditions, JSONQueryValue value) {
        this.entity = entity;
        this.conditions = conditions;
        this.value = value;
    }

    public String entity() {
        return this.entity;
    }

    public List<QueryCondition> conditions() {
        return Collections.unmodifiableList(this.conditions);
    }

    public Optional<JSONQueryValue> value() {
        return Optional.ofNullable(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateQuery)) {
            return false;
        }
        UpdateQuery that = (UpdateQuery)o;
        return Objects.equals(this.entity, that.entity) && Objects.equals(this.conditions, that.conditions);
    }

    public int hashCode() {
        return Objects.hash(this.entity, this.conditions);
    }

    public String toString() {
        if (this.conditions.isEmpty() && this.value != null) {
            return "update " + this.entity + " " + this.value;
        }
        return "update " + this.entity + " (" + this.conditions + ") ";
    }

    public static UpdateQuery parse(String query) {
        Objects.requireNonNull(query, "query is required");
        return new UpdateQueryConverter().apply(query);
    }
}

