/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.query;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.jnosql.communication.query.QueryCondition;
import org.eclipse.jnosql.communication.query.QueryValue;
import org.eclipse.jnosql.communication.query.ValueType;

public class ConditionQueryValue
implements QueryValue<List<QueryCondition>> {
    private final List<QueryCondition> conditions;

    private ConditionQueryValue(List<QueryCondition> conditions) {
        this.conditions = conditions;
    }

    @Override
    public List<QueryCondition> get() {
        return Collections.unmodifiableList(this.conditions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConditionQueryValue)) {
            return false;
        }
        ConditionQueryValue that = (ConditionQueryValue)o;
        return Objects.equals(this.conditions, that.conditions);
    }

    public int hashCode() {
        return Objects.hashCode(this.conditions);
    }

    public String toString() {
        return this.conditions.toString();
    }

    public static ConditionQueryValue of(List<QueryCondition> conditions) {
        Objects.requireNonNull(conditions, "conditions is required");
        return new ConditionQueryValue(conditions);
    }

    @Override
    public ValueType type() {
        return ValueType.CONDITION;
    }
}

