/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.query;

import jakarta.data.repository.Sort;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jnosql.communication.query.SelectQuery;
import org.eclipse.jnosql.communication.query.SelectQueryConverter;
import org.eclipse.jnosql.communication.query.Where;

final class DefaultSelectQuery
implements SelectQuery {
    private final String entity;
    private final List<String> fields;
    private final List<Sort> sorts;
    private final long skip;
    private final long limit;
    private final Where where;

    DefaultSelectQuery(String entity, List<String> fields, List<Sort> sorts, long skip, long limit, Where where) {
        this.entity = entity;
        this.fields = fields;
        this.sorts = sorts;
        this.skip = skip;
        this.limit = limit;
        this.where = where;
    }

    @Override
    public List<String> fields() {
        return this.fields;
    }

    @Override
    public String entity() {
        return this.entity;
    }

    @Override
    public Optional<Where> where() {
        return Optional.ofNullable(this.where);
    }

    @Override
    public long skip() {
        return this.skip;
    }

    @Override
    public long limit() {
        return this.limit;
    }

    @Override
    public List<Sort> orderBy() {
        return this.sorts;
    }

    static DefaultSelectQuery parse(String query) {
        Objects.requireNonNull(query, "query is required");
        return new SelectQueryConverter().apply(query);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultSelectQuery)) {
            return false;
        }
        DefaultSelectQuery that = (DefaultSelectQuery)o;
        return this.skip == that.skip && this.limit == that.limit && Objects.equals(this.entity, that.entity) && Objects.equals(this.fields, that.fields) && Objects.equals(this.sorts, that.sorts) && Objects.equals(this.where, that.where);
    }

    public int hashCode() {
        return Objects.hash(this.entity, this.fields, this.sorts, this.skip, this.limit, this.where);
    }
}

