/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.query;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.jnosql.communication.query.DelQueryConverter;
import org.eclipse.jnosql.communication.query.Query;
import org.eclipse.jnosql.communication.query.QueryValue;

public final class DelQuery
implements Query {
    private final List<QueryValue<?>> keys;

    DelQuery(List<QueryValue<?>> keys) {
        this.keys = keys;
    }

    public List<QueryValue<?>> keys() {
        return Collections.unmodifiableList(this.keys);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DelQuery delQuery = (DelQuery)o;
        return Objects.equals(this.keys, delQuery.keys);
    }

    public int hashCode() {
        return Objects.hashCode(this.keys);
    }

    public String toString() {
        return "DelQuery{keys=" + this.keys + "}";
    }

    public static DelQuery parse(String query) {
        Objects.requireNonNull(query, "query is required");
        return new DelQueryConverter().apply(query);
    }
}

