/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.query;

import java.util.Objects;
import org.eclipse.jnosql.communication.query.QueryValue;
import org.eclipse.jnosql.communication.query.ValueType;
import org.eclipse.jnosql.query.grammar.QueryParser;

public final class NumberQueryValue
implements QueryValue<Number> {
    private final Number number;

    NumberQueryValue(Number number) {
        this.number = number;
    }

    @Override
    public Number get() {
        return this.number;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NumberQueryValue)) {
            return false;
        }
        NumberQueryValue that = (NumberQueryValue)o;
        return Objects.equals(this.number, that.number);
    }

    public int hashCode() {
        return Objects.hashCode(this.number);
    }

    public String toString() {
        return this.number.toString();
    }

    @Override
    public ValueType type() {
        return ValueType.NUMBER;
    }

    static NumberQueryValue of(QueryParser.NumberContext context) {
        String value = context.getText();
        if (value.contains(".")) {
            return new NumberQueryValue(Double.valueOf(value));
        }
        return new NumberQueryValue(Long.valueOf(value));
    }
}

