/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.query.method;

import java.util.Objects;
import org.eclipse.jnosql.communication.Condition;
import org.eclipse.jnosql.communication.query.QueryCondition;
import org.eclipse.jnosql.communication.query.QueryValue;
import org.eclipse.jnosql.communication.query.method.MethodParamQueryValue;

final class MethodCondition
implements QueryCondition {
    private final String name;
    private final Condition condition;
    private final QueryValue<?> value;

    MethodCondition(String name, Condition condition) {
        this.name = name;
        this.condition = condition;
        this.value = new MethodParamQueryValue(name);
    }

    MethodCondition(String name, Condition condition, QueryValue<?> value) {
        this.name = name;
        this.condition = condition;
        this.value = value;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Condition condition() {
        return this.condition;
    }

    @Override
    public QueryValue<?> value() {
        return this.value;
    }

    public String toString() {
        return this.name + " " + this.condition + " " + this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodCondition that = (MethodCondition)o;
        return Objects.equals(this.name, that.name) && this.condition == that.condition && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.condition, this.value);
    }
}

