/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.jnosql.communication.Condition;
import org.eclipse.jnosql.communication.query.AbstractSupplier;
import org.eclipse.jnosql.communication.query.ConditionQueryValue;
import org.eclipse.jnosql.communication.query.DefaultArrayQueryValue;
import org.eclipse.jnosql.communication.query.DefaultQueryCondition;
import org.eclipse.jnosql.communication.query.QueryCondition;
import org.eclipse.jnosql.communication.query.QueryValue;
import org.eclipse.jnosql.communication.query.StringQueryValue;
import org.eclipse.jnosql.communication.query.ValueConverter;
import org.eclipse.jnosql.communication.query.Where;
import org.eclipse.jnosql.query.grammar.QueryParser;

abstract class AbstractWhereSupplier
extends AbstractSupplier {
    protected Where where;
    protected QueryCondition condition;
    protected boolean and = true;

    AbstractWhereSupplier() {
    }

    @Override
    protected void runQuery(String query) {
        super.runQuery(query);
        if (Objects.nonNull(this.condition)) {
            this.where = new Where(this.condition);
        }
    }

    @Override
    public void exitEq(QueryParser.EqContext ctx) {
        boolean hasNot = Objects.nonNull((Object)ctx.not());
        String name = ctx.name().getText();
        QueryValue<?> value = ValueConverter.get(ctx.value());
        this.checkCondition(new DefaultQueryCondition(name, Condition.EQUALS, value), hasNot);
    }

    @Override
    public void exitLt(QueryParser.LtContext ctx) {
        boolean hasNot = Objects.nonNull((Object)ctx.not());
        String name = ctx.name().getText();
        QueryValue<?> value = ValueConverter.get(ctx.value());
        this.checkCondition(new DefaultQueryCondition(name, Condition.LESSER_THAN, value), hasNot);
    }

    @Override
    public void exitLte(QueryParser.LteContext ctx) {
        boolean hasNot = Objects.nonNull((Object)ctx.not());
        String name = ctx.name().getText();
        QueryValue<?> value = ValueConverter.get(ctx.value());
        this.checkCondition(new DefaultQueryCondition(name, Condition.LESSER_EQUALS_THAN, value), hasNot);
    }

    @Override
    public void exitGt(QueryParser.GtContext ctx) {
        boolean hasNot = Objects.nonNull((Object)ctx.not());
        String name = ctx.name().getText();
        QueryValue<?> value = ValueConverter.get(ctx.value());
        this.checkCondition(new DefaultQueryCondition(name, Condition.GREATER_THAN, value), hasNot);
    }

    @Override
    public void exitGte(QueryParser.GteContext ctx) {
        boolean hasNot = Objects.nonNull((Object)ctx.not());
        String name = ctx.name().getText();
        QueryValue<?> value = ValueConverter.get(ctx.value());
        this.checkCondition(new DefaultQueryCondition(name, Condition.GREATER_EQUALS_THAN, value), hasNot);
    }

    @Override
    public void exitIn(QueryParser.InContext ctx) {
        boolean hasNot = Objects.nonNull((Object)ctx.not());
        String name = ctx.name().getText();
        QueryValue[] values = (QueryValue[])ctx.value().stream().map(ValueConverter::get).toArray(QueryValue[]::new);
        DefaultArrayQueryValue value = DefaultArrayQueryValue.of(values);
        this.checkCondition(new DefaultQueryCondition(name, Condition.IN, value), hasNot);
    }

    @Override
    public void exitLike(QueryParser.LikeContext ctx) {
        boolean hasNot = Objects.nonNull((Object)ctx.not());
        String name = ctx.name().getText();
        StringQueryValue value = StringQueryValue.of(ctx.string());
        this.checkCondition(new DefaultQueryCondition(name, Condition.LIKE, value), hasNot);
    }

    @Override
    public void exitBetween(QueryParser.BetweenContext ctx) {
        boolean hasNot = Objects.nonNull((Object)ctx.not());
        String name = ctx.name().getText();
        QueryValue[] values = (QueryValue[])ctx.value().stream().map(ValueConverter::get).toArray(QueryValue[]::new);
        this.checkCondition(new DefaultQueryCondition(name, Condition.BETWEEN, DefaultArrayQueryValue.of(values)), hasNot);
    }

    @Override
    public void exitAnd(QueryParser.AndContext ctx) {
        this.and = true;
    }

    @Override
    public void exitOr(QueryParser.OrContext ctx) {
        this.and = false;
    }

    private void checkCondition(QueryCondition condition, boolean hasNot) {
        QueryCondition newCondition = this.checkNotCondition(condition, hasNot);
        if (Objects.isNull(this.condition)) {
            this.condition = newCondition;
            return;
        }
        if (this.and) {
            this.appendCondition(Condition.AND, newCondition);
        } else {
            this.appendCondition(Condition.OR, newCondition);
        }
    }

    private void appendCondition(Condition operator, QueryCondition newCondition) {
        if (operator.equals((Object)this.condition.condition())) {
            ConditionQueryValue conditionValue = (ConditionQueryValue)ConditionQueryValue.class.cast(this.condition.value());
            ArrayList<QueryCondition> conditions = new ArrayList<QueryCondition>((Collection<QueryCondition>)conditionValue.get());
            conditions.add(newCondition);
            this.condition = new DefaultQueryCondition("_" + operator.name(), operator, ConditionQueryValue.of(conditions));
        } else if (this.isNotAppendable()) {
            List<QueryCondition> conditions = Arrays.asList(this.condition, newCondition);
            this.condition = new DefaultQueryCondition("_" + operator.name(), operator, ConditionQueryValue.of(conditions));
        } else {
            Object conditions = ((ConditionQueryValue)ConditionQueryValue.class.cast(this.condition.value())).get();
            QueryCondition lastCondition = (QueryCondition)conditions.get(conditions.size() - 1);
            if (this.isAppendable(lastCondition) && operator.equals((Object)lastCondition.condition())) {
                ArrayList<QueryCondition> lastConditions = new ArrayList<QueryCondition>((Collection<QueryCondition>)((ConditionQueryValue)ConditionQueryValue.class.cast(lastCondition.value())).get());
                lastConditions.add(newCondition);
                DefaultQueryCondition newAppendable = new DefaultQueryCondition("_" + operator.name(), operator, ConditionQueryValue.of(lastConditions));
                ArrayList<QueryCondition> newConditions = new ArrayList<QueryCondition>(conditions.subList(0, conditions.size() - 1));
                newConditions.add(newAppendable);
                this.condition = new DefaultQueryCondition(this.condition.name(), this.condition.condition(), ConditionQueryValue.of(newConditions));
            } else {
                DefaultQueryCondition newAppendable = new DefaultQueryCondition("_" + operator.name(), operator, ConditionQueryValue.of(Collections.singletonList(newCondition)));
                ArrayList<QueryCondition> newConditions = new ArrayList<QueryCondition>((Collection<QueryCondition>)conditions);
                newConditions.add(newAppendable);
                this.condition = new DefaultQueryCondition(this.condition.name(), this.condition.condition(), ConditionQueryValue.of(newConditions));
            }
        }
    }

    private boolean isAppendable(QueryCondition condition) {
        return Condition.AND.equals((Object)condition.condition()) || Condition.OR.equals((Object)condition.condition());
    }

    private boolean isNotAppendable() {
        return !this.isAppendable(this.condition);
    }

    private QueryCondition checkNotCondition(QueryCondition condition, boolean hasNot) {
        if (hasNot) {
            ConditionQueryValue conditions = ConditionQueryValue.of(Collections.singletonList(condition));
            return new DefaultQueryCondition("_NOT", Condition.NOT, conditions);
        }
        return condition;
    }
}

