/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.query;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.jnosql.communication.Condition;
import org.eclipse.jnosql.communication.query.AbstractSupplier;
import org.eclipse.jnosql.communication.query.DefaultQueryCondition;
import org.eclipse.jnosql.communication.query.Durations;
import org.eclipse.jnosql.communication.query.InsertQuery;
import org.eclipse.jnosql.communication.query.JSONQueryValue;
import org.eclipse.jnosql.communication.query.QueryValue;
import org.eclipse.jnosql.communication.query.ValueConverter;
import org.eclipse.jnosql.query.grammar.QueryParser;

public final class InsertQueryConverter
extends AbstractSupplier
implements Function<String, InsertQuery> {
    private String entity;
    private List<DefaultQueryCondition> conditions = Collections.emptyList();
    private Duration duration;
    private JSONQueryValue value;

    @Override
    Function<QueryParser, ParseTree> getParserTree() {
        return QueryParser::insert;
    }

    @Override
    public void exitEntity(QueryParser.EntityContext ctx) {
        this.entity = ctx.getText();
    }

    @Override
    public void exitChanges(QueryParser.ChangesContext ctx) {
        this.conditions = ctx.change().stream().map(this::getCondition).collect(Collectors.toList());
    }

    @Override
    public void enterJson(QueryParser.JsonContext ctx) {
        this.value = JSONQueryValue.of(ctx);
    }

    private DefaultQueryCondition getCondition(QueryParser.ChangeContext changeContext) {
        String name = changeContext.name().getText();
        QueryValue<?> queryValue = ValueConverter.get(changeContext.value());
        return new DefaultQueryCondition(name, Condition.EQUALS, queryValue);
    }

    @Override
    public void exitTtl(QueryParser.TtlContext ctx) {
        this.duration = Durations.get(ctx);
    }

    @Override
    public InsertQuery apply(String query) {
        this.runQuery(query);
        return new InsertQuery(this.entity, this.duration, this.conditions, this.value);
    }
}

