/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.query;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.jnosql.communication.query.GetQueryConverter;
import org.eclipse.jnosql.communication.query.Query;
import org.eclipse.jnosql.communication.query.QueryValue;

public final class GetQuery
implements Query {
    private final List<QueryValue<?>> keys;

    GetQuery(List<QueryValue<?>> keys) {
        this.keys = keys;
    }

    public List<QueryValue<?>> keys() {
        return Collections.unmodifiableList(this.keys);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetQuery)) {
            return false;
        }
        GetQuery that = (GetQuery)o;
        return Objects.equals(this.keys, that.keys);
    }

    public int hashCode() {
        return Objects.hashCode(this.keys);
    }

    public String toString() {
        return this.keys.toString();
    }

    public static GetQuery parse(String query) {
        Objects.requireNonNull(query, "query is required");
        return new GetQueryConverter().apply(query);
    }
}

