/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.query;

import java.util.Objects;
import org.eclipse.jnosql.communication.QueryException;
import org.eclipse.jnosql.communication.query.BooleanQueryValue;
import org.eclipse.jnosql.communication.query.DefaultArrayQueryValue;
import org.eclipse.jnosql.communication.query.DefaultQueryValue;
import org.eclipse.jnosql.communication.query.Elements;
import org.eclipse.jnosql.communication.query.FunctionQueryValue;
import org.eclipse.jnosql.communication.query.JSONQueryValue;
import org.eclipse.jnosql.communication.query.NumberQueryValue;
import org.eclipse.jnosql.communication.query.QueryValue;
import org.eclipse.jnosql.communication.query.StringQueryValue;
import org.eclipse.jnosql.query.grammar.QueryParser;

final class ValueConverter {
    private static final String MESSAGE = "There is an error when trying to convert the value";

    private ValueConverter() {
    }

    static QueryValue<?> get(QueryParser.ValueContext context) {
        if (Objects.nonNull((Object)context.number())) {
            return NumberQueryValue.of(context.number());
        }
        if (Objects.nonNull((Object)context.string())) {
            return StringQueryValue.of(context.string());
        }
        if (Objects.nonNull((Object)context.bool())) {
            return BooleanQueryValue.of(context.bool());
        }
        if (Objects.nonNull((Object)context.json())) {
            return JSONQueryValue.of(context.json());
        }
        if (Objects.nonNull((Object)context.parameter())) {
            return DefaultQueryValue.of(context.parameter());
        }
        if (Objects.nonNull((Object)context.function())) {
            return FunctionQueryValue.of(context.function());
        }
        if (Objects.nonNull((Object)context.array())) {
            QueryValue[] elements = (QueryValue[])context.array().element().stream().map(Elements::getElement).toArray(QueryValue[]::new);
            return DefaultArrayQueryValue.of(elements);
        }
        throw new QueryException(MESSAGE);
    }
}

