/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.semistructured;

import jakarta.data.exceptions.NonUniqueResultException;
import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.jnosql.communication.Params;
import org.eclipse.jnosql.communication.QueryException;
import org.eclipse.jnosql.communication.semistructured.CommunicationEntity;
import org.eclipse.jnosql.communication.semistructured.DatabaseManager;
import org.eclipse.jnosql.communication.semistructured.DeleteQuery;
import org.eclipse.jnosql.communication.semistructured.SelectQuery;

public final class CommunicationPreparedStatement {
    private final CommunicationEntity entity;
    private final SelectQuery selectQuery;
    private final DeleteQuery deleteQuery;
    private final PreparedStatementType type;
    private final Params params;
    private final String query;
    private final List<String> paramsLeft;
    private final Duration duration;
    private final DatabaseManager manager;

    private CommunicationPreparedStatement(CommunicationEntity entity, SelectQuery selectQuery, DeleteQuery deleteQuery, PreparedStatementType type, Params params, String query, List<String> paramsLeft, Duration duration, DatabaseManager manager) {
        this.entity = entity;
        this.selectQuery = selectQuery;
        this.deleteQuery = deleteQuery;
        this.type = type;
        this.params = params;
        this.query = query;
        this.paramsLeft = paramsLeft;
        this.manager = manager;
        this.duration = duration;
    }

    public CommunicationPreparedStatement bind(String name, Object value) {
        Objects.requireNonNull(name, "name is required");
        Objects.requireNonNull(value, "value is required");
        this.paramsLeft.remove(name);
        this.params.bind(name, value);
        return this;
    }

    public Optional<SelectQuery> select() {
        return Optional.ofNullable(this.selectQuery);
    }

    public Stream<CommunicationEntity> result() {
        if (!this.paramsLeft.isEmpty()) {
            throw new QueryException("Check all the parameters before execute the query, params left: " + this.paramsLeft);
        }
        switch (this.type) {
            case SELECT: {
                return this.manager.select(this.selectQuery);
            }
            case DELETE: {
                this.manager.delete(this.deleteQuery);
                return Stream.empty();
            }
            case UPDATE: {
                return Stream.of(this.manager.update(this.entity));
            }
            case INSERT: {
                if (Objects.isNull(this.duration)) {
                    return Stream.of(this.manager.insert(this.entity));
                }
                return Stream.of(this.manager.insert(this.entity, this.duration));
            }
        }
        throw new UnsupportedOperationException("there is not support to operation type: " + this.type);
    }

    public Optional<CommunicationEntity> singleResult() {
        Stream<CommunicationEntity> entities = this.result();
        Iterator iterator = entities.iterator();
        if (!iterator.hasNext()) {
            return Optional.empty();
        }
        CommunicationEntity next = (CommunicationEntity)iterator.next();
        if (!iterator.hasNext()) {
            return Optional.of(next);
        }
        throw new NonUniqueResultException("The select returns more than one entity, select: " + this.query);
    }

    public String toString() {
        return this.query;
    }

    static CommunicationPreparedStatement select(SelectQuery selectQuery, Params params, String query, DatabaseManager manager) {
        return new CommunicationPreparedStatement(null, selectQuery, null, PreparedStatementType.SELECT, params, query, params.getParametersNames(), null, manager);
    }

    static CommunicationPreparedStatement delete(DeleteQuery deleteQuery, Params params, String query, DatabaseManager manager) {
        return new CommunicationPreparedStatement(null, null, deleteQuery, PreparedStatementType.DELETE, params, query, params.getParametersNames(), null, manager);
    }

    static CommunicationPreparedStatement insert(CommunicationEntity entity, Params params, String query, Duration duration, DatabaseManager manager) {
        return new CommunicationPreparedStatement(entity, null, null, PreparedStatementType.INSERT, params, query, params.getParametersNames(), duration, manager);
    }

    static CommunicationPreparedStatement update(CommunicationEntity entity, Params params, String query, DatabaseManager manager) {
        return new CommunicationPreparedStatement(entity, null, null, PreparedStatementType.UPDATE, params, query, params.getParametersNames(), null, manager);
    }

    static enum PreparedStatementType {
        SELECT,
        DELETE,
        UPDATE,
        INSERT;

    }
}

