/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.semistructured;

import java.util.List;
import org.eclipse.jnosql.communication.Params;
import org.eclipse.jnosql.communication.QueryException;
import org.eclipse.jnosql.communication.query.JSONQueryValue;
import org.eclipse.jnosql.communication.semistructured.CommunicationEntity;
import org.eclipse.jnosql.communication.semistructured.CommunicationObserverParser;
import org.eclipse.jnosql.communication.semistructured.ConditionQuerySupplier;
import org.eclipse.jnosql.communication.semistructured.Conditions;
import org.eclipse.jnosql.communication.semistructured.CriteriaCondition;
import org.eclipse.jnosql.communication.semistructured.Element;
import org.eclipse.jnosql.communication.semistructured.JsonObjects;

abstract class ConditionQueryParser {
    ConditionQueryParser() {
    }

    protected CommunicationEntity getEntity(ConditionQuerySupplier query, String columnFamily, Params params, CommunicationObserverParser observer) {
        CommunicationEntity entity = CommunicationEntity.of(columnFamily);
        if (query.useJSONCondition()) {
            JSONQueryValue jsonValue = query.value().orElseThrow(() -> new QueryException("It is an invalid state of either Update or Insert."));
            List<Element> elements = JsonObjects.getColumns(jsonValue.get());
            entity.addAll(elements);
            return entity;
        }
        query.conditions().stream().map(c -> Conditions.getCondition(c, params, observer, columnFamily)).map(CriteriaCondition::element).forEach(entity::add);
        return entity;
    }
}

