/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.semistructured;

import jakarta.data.Sort;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.eclipse.jnosql.communication.semistructured.CriteriaCondition;
import org.eclipse.jnosql.communication.semistructured.DatabaseManager;
import org.eclipse.jnosql.communication.semistructured.DefaultDeleteQuery;
import org.eclipse.jnosql.communication.semistructured.DeleteQuery;

class DefaultDeleteQueryBuilder
implements DeleteQuery.DeleteQueryBuilder {
    private final List<String> columns = new ArrayList<String>();
    private final List<Sort<?>> sorts = new ArrayList();
    private String entity;
    private CriteriaCondition condition;

    DefaultDeleteQueryBuilder() {
    }

    @Override
    public DeleteQuery.DeleteQueryBuilder delete(String column) {
        Objects.requireNonNull(column, "column is required");
        this.columns.add(column);
        return this;
    }

    @Override
    public DeleteQuery.DeleteQueryBuilder delete(String ... columns) {
        Consumer<String> validNull = c -> Objects.requireNonNull(c, "there is null column in the query");
        Consumer<String> consume = this.columns::add;
        Stream.of(columns).forEach(validNull.andThen(consume));
        return this;
    }

    @Override
    public DeleteQuery.DeleteQueryBuilder from(String entity) {
        Objects.requireNonNull(entity, "entity is required");
        this.entity = entity;
        return this;
    }

    @Override
    public DeleteQuery.DeleteQueryBuilder where(CriteriaCondition condition) {
        Objects.requireNonNull(condition, "condition is required");
        this.condition = condition;
        return this;
    }

    @Override
    public DeleteQuery build() {
        if (Objects.isNull(this.entity)) {
            throw new IllegalArgumentException("The document collection is mandatory to build");
        }
        return new DefaultDeleteQuery(this.entity, this.condition, this.columns);
    }

    @Override
    public void delete(DatabaseManager manager) {
        Objects.requireNonNull(manager, "manager is required");
        manager.delete(this.build());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultDeleteQueryBuilder that = (DefaultDeleteQueryBuilder)o;
        return Objects.equals(this.columns, that.columns) && Objects.equals(this.sorts, that.sorts) && Objects.equals(this.entity, that.entity) && Objects.equals(this.condition, that.condition);
    }

    public int hashCode() {
        return Objects.hash(this.columns, this.sorts, this.entity, this.condition);
    }

    public String toString() {
        return "DefaultDeleteQueryBuilder{columns=" + this.columns + ", sorts=" + this.sorts + ", entity='" + this.entity + "', condition=" + this.condition + "}";
    }
}

