/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.semistructured;

import java.util.List;
import java.util.Objects;
import org.eclipse.jnosql.communication.semistructured.BaseQueryBuilder;
import org.eclipse.jnosql.communication.semistructured.DatabaseManager;
import org.eclipse.jnosql.communication.semistructured.DefaultDeleteQuery;
import org.eclipse.jnosql.communication.semistructured.DeleteQuery;

class DefaultFluentDeleteQueryBuilder
extends BaseQueryBuilder
implements DeleteQuery.EntityDelete,
DeleteQuery.DeleteFrom,
DeleteQuery.DeleteWhere,
DeleteQuery.DeleteNotCondition {
    private String entity;
    private final List<String> columns;

    DefaultFluentDeleteQueryBuilder(List<String> columns) {
        this.columns = columns;
    }

    @Override
    public DeleteQuery.DeleteFrom from(String entity) {
        Objects.requireNonNull(entity, "entity is required");
        this.entity = entity;
        return this;
    }

    @Override
    public DeleteQuery.DeleteNameCondition where(String name) {
        Objects.requireNonNull(name, "name is required");
        this.name = name;
        return this;
    }

    @Override
    public DeleteQuery.DeleteNameCondition and(String name) {
        Objects.requireNonNull(name, "name is required");
        this.name = name;
        this.and = true;
        return this;
    }

    @Override
    public DeleteQuery.DeleteNameCondition or(String name) {
        Objects.requireNonNull(name, "name is required");
        this.name = name;
        this.and = false;
        return this;
    }

    @Override
    public DeleteQuery.DeleteNotCondition not() {
        this.negate = true;
        return this;
    }

    @Override
    public <T> DeleteQuery.DeleteWhere eq(T value) {
        this.eqImpl(value);
        return this;
    }

    @Override
    public DeleteQuery.DeleteWhere like(String value) {
        this.likeImpl(value);
        return this;
    }

    @Override
    public <T> DeleteQuery.DeleteWhere gt(T value) {
        this.gtImpl(value);
        return this;
    }

    @Override
    public <T> DeleteQuery.DeleteWhere gte(T value) {
        this.gteImpl(value);
        return this;
    }

    @Override
    public <T> DeleteQuery.DeleteWhere lt(T value) {
        this.ltImpl(value);
        return this;
    }

    @Override
    public <T> DeleteQuery.DeleteWhere lte(T value) {
        this.lteImpl(value);
        return this;
    }

    @Override
    public <T> DeleteQuery.DeleteWhere between(T valueA, T valueB) {
        this.betweenImpl(valueA, valueB);
        return this;
    }

    @Override
    public <T> DeleteQuery.DeleteWhere in(Iterable<T> values) {
        this.inImpl(values);
        return this;
    }

    @Override
    public DeleteQuery build() {
        return new DefaultDeleteQuery(this.entity, this.condition, this.columns);
    }

    @Override
    public void delete(DatabaseManager manager) {
        Objects.requireNonNull(manager, "manager is required");
        manager.delete(this.build());
    }
}

