/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.semistructured;

import jakarta.data.Sort;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jnosql.communication.semistructured.CriteriaCondition;
import org.eclipse.jnosql.communication.semistructured.SelectQuery;

record DefaultSelectQuery(long limit, long skip, String name, List<String> columns, List<Sort<?>> sorts, CriteriaCondition criteriaCondition) implements SelectQuery
{
    private final List<String> columns;
    private final List<Sort<?>> sorts;

    @Override
    public Optional<CriteriaCondition> condition() {
        return Optional.ofNullable(this.criteriaCondition).map(CriteriaCondition::readOnly);
    }

    @Override
    public List<String> columns() {
        return Collections.unmodifiableList(this.columns);
    }

    @Override
    public List<Sort<?>> sorts() {
        return Collections.unmodifiableList(this.sorts);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SelectQuery)) {
            return false;
        }
        SelectQuery that = (SelectQuery)o;
        return this.limit == that.limit() && this.skip == that.skip() && Objects.equals(this.name, that.name()) && Objects.equals(this.columns, that.columns()) && Objects.equals(this.sorts, that.sorts()) && Objects.equals(this.criteriaCondition, that.condition().orElse(null));
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.limit, this.skip, this.name, this.columns, this.sorts, this.criteriaCondition);
    }

    static SelectQuery countBy(SelectQuery query) {
        return new DefaultSelectQuery(0L, 0L, query.name(), query.columns(), Collections.emptyList(), query.condition().orElse(null));
    }

    static SelectQuery existsBy(SelectQuery query) {
        return new DefaultSelectQuery(1L, 0L, query.name(), query.columns(), Collections.emptyList(), query.condition().orElse(null));
    }
}

