/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.semistructured;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.eclipse.jnosql.communication.semistructured.CriteriaCondition;
import org.eclipse.jnosql.communication.semistructured.DatabaseManager;
import org.eclipse.jnosql.communication.semistructured.DefaultDeleteQueryBuilder;
import org.eclipse.jnosql.communication.semistructured.DefaultFluentDeleteQueryBuilder;

public interface DeleteQuery {
    public String name();

    public Optional<CriteriaCondition> condition();

    public List<String> columns();

    public static EntityDelete delete(String ... columns) {
        Stream.of(columns).forEach(d -> Objects.requireNonNull(d, "There is a null column in the query"));
        return new DefaultFluentDeleteQueryBuilder(Arrays.asList(columns));
    }

    public static EntityDelete delete() {
        return new DefaultFluentDeleteQueryBuilder(Collections.emptyList());
    }

    public static DeleteQueryBuilder builder(String ... documents) {
        Stream.of(documents).forEach(d -> Objects.requireNonNull(d, "There is a null document in the query"));
        DefaultDeleteQueryBuilder builder = new DefaultDeleteQueryBuilder();
        Stream.of(documents).forEach(builder::delete);
        return builder;
    }

    public static DeleteQueryBuilder builder() {
        return new DefaultDeleteQueryBuilder();
    }

    public static interface DeleteQueryBuilder {
        public DeleteQueryBuilder delete(String var1);

        public DeleteQueryBuilder delete(String ... var1);

        public DeleteQueryBuilder from(String var1);

        public DeleteQueryBuilder where(CriteriaCondition var1);

        public DeleteQuery build();

        public void delete(DatabaseManager var1);
    }

    public static interface DeleteWhere
    extends DeleteQueryBuild {
        public DeleteNameCondition and(String var1);

        public DeleteNameCondition or(String var1);
    }

    public static interface DeleteQueryBuild {
        public DeleteQuery build();

        public void delete(DatabaseManager var1);
    }

    public static interface DeleteNotCondition
    extends DeleteNameCondition {
    }

    public static interface DeleteNameCondition {
        public <T> DeleteWhere eq(T var1);

        public DeleteWhere like(String var1);

        public <T> DeleteWhere gt(T var1);

        public <T> DeleteWhere gte(T var1);

        public <T> DeleteWhere lt(T var1);

        public <T> DeleteWhere lte(T var1);

        public <T> DeleteWhere between(T var1, T var2);

        public <T> DeleteWhere in(Iterable<T> var1);

        public DeleteNotCondition not();
    }

    public static interface DeleteFrom
    extends DeleteQueryBuild {
        public DeleteNameCondition where(String var1);
    }

    public static interface DeleteQueryBuilderProvider
    extends Function<String[], DeleteQueryBuilder>,
    Supplier<DeleteQueryBuilder> {
    }

    public static interface DeleteProvider
    extends Function<String[], EntityDelete>,
    Supplier<EntityDelete> {
    }

    public static interface EntityDelete {
        public DeleteFrom from(String var1);
    }
}

