/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.semistructured;

import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jnosql.communication.Params;
import org.eclipse.jnosql.communication.QueryException;
import org.eclipse.jnosql.communication.query.DeleteQueryConverter;
import org.eclipse.jnosql.communication.semistructured.CommunicationEntity;
import org.eclipse.jnosql.communication.semistructured.CommunicationObserverParser;
import org.eclipse.jnosql.communication.semistructured.CommunicationPreparedStatement;
import org.eclipse.jnosql.communication.semistructured.Conditions;
import org.eclipse.jnosql.communication.semistructured.CriteriaCondition;
import org.eclipse.jnosql.communication.semistructured.DatabaseManager;
import org.eclipse.jnosql.communication.semistructured.DefaultDeleteQuery;
import org.eclipse.jnosql.communication.semistructured.DeleteQuery;
import org.eclipse.jnosql.communication.semistructured.DeleteQueryParams;

public final class DeleteQueryParser
implements BiFunction<org.eclipse.jnosql.communication.query.DeleteQuery, CommunicationObserverParser, DeleteQueryParams> {
    Stream<CommunicationEntity> query(String query, DatabaseManager manager, CommunicationObserverParser observer) {
        DeleteQuery deleteQuery = this.getQuery(query, observer);
        manager.delete(deleteQuery);
        return Stream.empty();
    }

    CommunicationPreparedStatement prepare(String query, DatabaseManager manager, CommunicationObserverParser observer) {
        Params params = Params.newParams();
        DeleteQuery deleteQuery = this.getQuery(query, params, observer);
        return CommunicationPreparedStatement.delete(deleteQuery, params, query, manager);
    }

    @Override
    public DeleteQueryParams apply(org.eclipse.jnosql.communication.query.DeleteQuery deleteQuery, CommunicationObserverParser communicationObserverParser) {
        Objects.requireNonNull(deleteQuery, "deleteQuery is required");
        Objects.requireNonNull(communicationObserverParser, "columnObserverParser is required");
        Params params = Params.newParams();
        DeleteQuery query = this.getQuery(params, communicationObserverParser, deleteQuery);
        return new DeleteQueryParams(query, params);
    }

    private DeleteQuery getQuery(String query, Params params, CommunicationObserverParser observer) {
        DeleteQueryConverter converter = new DeleteQueryConverter();
        org.eclipse.jnosql.communication.query.DeleteQuery deleteQuery = converter.apply(query);
        return this.getQuery(params, observer, deleteQuery);
    }

    private DeleteQuery getQuery(Params params, CommunicationObserverParser observer, org.eclipse.jnosql.communication.query.DeleteQuery deleteQuery) {
        String columnFamily = observer.fireEntity(deleteQuery.entity());
        List<String> columns = deleteQuery.fields().stream().map(f -> observer.fireField(columnFamily, (String)f)).collect(Collectors.toList());
        CriteriaCondition condition = deleteQuery.where().map(c -> Conditions.getCondition(c, params, observer, columnFamily)).orElse(null);
        return new DefaultDeleteQuery(columnFamily, condition, columns);
    }

    private DeleteQuery getQuery(String query, CommunicationObserverParser observer) {
        DeleteQueryConverter converter = new DeleteQueryConverter();
        org.eclipse.jnosql.communication.query.DeleteQuery deleteQuery = converter.apply(query);
        String columnFamily = observer.fireEntity(deleteQuery.entity());
        List<String> columns = deleteQuery.fields().stream().map(f -> observer.fireField(columnFamily, (String)f)).collect(Collectors.toList());
        Params params = Params.newParams();
        CriteriaCondition condition = deleteQuery.where().map(c -> Conditions.getCondition(c, params, observer, columnFamily)).orElse(null);
        if (params.isNotEmpty()) {
            throw new QueryException("To run a query with a parameter use a PrepareStatement instead.");
        }
        return new DefaultDeleteQuery(columnFamily, condition, columns);
    }
}

