/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.semistructured;

import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.jnosql.communication.Params;
import org.eclipse.jnosql.communication.QueryException;
import org.eclipse.jnosql.communication.query.InsertQuery;
import org.eclipse.jnosql.communication.query.InsertQueryConverter;
import org.eclipse.jnosql.communication.query.JSONQueryValue;
import org.eclipse.jnosql.communication.query.QueryCondition;
import org.eclipse.jnosql.communication.semistructured.CommunicationEntity;
import org.eclipse.jnosql.communication.semistructured.CommunicationObserverParser;
import org.eclipse.jnosql.communication.semistructured.CommunicationPreparedStatement;
import org.eclipse.jnosql.communication.semistructured.ConditionQueryParser;
import org.eclipse.jnosql.communication.semistructured.ConditionQuerySupplier;
import org.eclipse.jnosql.communication.semistructured.DatabaseManager;

final class InsertQueryParser
extends ConditionQueryParser {
    InsertQueryParser() {
    }

    Stream<CommunicationEntity> query(String query, DatabaseManager manager, CommunicationObserverParser observer) {
        InsertQueryConverter converter = new InsertQueryConverter();
        InsertQuery insertQuery = converter.apply(query);
        String columnFamily = insertQuery.entity();
        Params params = Params.newParams();
        CommunicationEntity entity = this.getEntity(insertQuery, columnFamily, params, observer);
        Optional ttl = insertQuery.ttl();
        if (params.isNotEmpty()) {
            throw new QueryException("To run a query with a parameter use a PrepareStatement instead.");
        }
        return ttl.map(duration -> Stream.of(manager.insert(entity, (Duration)duration))).orElseGet(() -> Stream.of(manager.insert(entity)));
    }

    CommunicationPreparedStatement prepare(String query, DatabaseManager manager, CommunicationObserverParser observer) {
        InsertQueryConverter converter = new InsertQueryConverter();
        InsertQuery insertQuery = converter.apply(query);
        String columnFamily = observer.fireEntity(insertQuery.entity());
        Params params = Params.newParams();
        Optional ttl = insertQuery.ttl();
        CommunicationEntity entity = this.getEntity(insertQuery, columnFamily, params, observer);
        return CommunicationPreparedStatement.insert(entity, params, query, ttl.orElse(null), manager);
    }

    private CommunicationEntity getEntity(InsertQuery insertQuery, String columnFamily, Params params, CommunicationObserverParser observer) {
        return this.getEntity(new InsertQueryConditionSupplier(insertQuery), columnFamily, params, observer);
    }

    private record InsertQueryConditionSupplier(InsertQuery query) implements ConditionQuerySupplier
    {
        @Override
        public List<QueryCondition> conditions() {
            return this.query.conditions();
        }

        @Override
        public Optional<JSONQueryValue> value() {
            return this.query.value();
        }
    }
}

