/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.semistructured;

import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.jnosql.communication.QueryException;
import org.eclipse.jnosql.communication.semistructured.CommunicationEntity;
import org.eclipse.jnosql.communication.semistructured.CommunicationObserverParser;
import org.eclipse.jnosql.communication.semistructured.CommunicationPreparedStatement;
import org.eclipse.jnosql.communication.semistructured.DatabaseManager;
import org.eclipse.jnosql.communication.semistructured.DeleteQueryParser;
import org.eclipse.jnosql.communication.semistructured.InsertQueryParser;
import org.eclipse.jnosql.communication.semistructured.SelectQueryParser;
import org.eclipse.jnosql.communication.semistructured.UpdateQueryParser;

public final class QueryParser {
    private final SelectQueryParser select = new SelectQueryParser();
    private final DeleteQueryParser delete = new DeleteQueryParser();
    private final InsertQueryParser insert = new InsertQueryParser();
    private final UpdateQueryParser update = new UpdateQueryParser();

    public Stream<CommunicationEntity> query(String query, DatabaseManager manager, CommunicationObserverParser observer) {
        String command;
        this.validation(query, manager, observer);
        return switch (command = query.substring(0, 6)) {
            case "select" -> this.select.query(query, manager, observer);
            case "delete" -> this.delete.query(query, manager, observer);
            case "insert" -> this.insert.query(query, manager, observer);
            case "update" -> this.update.query(query, manager, observer);
            default -> throw new QueryException(String.format("The command was not recognized at the query %s ", query));
        };
    }

    public CommunicationPreparedStatement prepare(String query, DatabaseManager manager, CommunicationObserverParser observer) {
        String command;
        this.validation(query, manager, observer);
        return switch (command = query.substring(0, 6)) {
            case "select" -> this.select.prepare(query, manager, observer);
            case "delete" -> this.delete.prepare(query, manager, observer);
            case "insert" -> this.insert.prepare(query, manager, observer);
            case "update" -> this.update.prepare(query, manager, observer);
            default -> throw new QueryException(String.format("The command was not recognized at the query %s ", query));
        };
    }

    private void validation(String query, DatabaseManager manager, CommunicationObserverParser observer) {
        Objects.requireNonNull(query, "query is required");
        Objects.requireNonNull(manager, "manager is required");
        Objects.requireNonNull(observer, "manager is observer");
        if (query.length() < 6) {
            throw new QueryException(String.format("The query %s is invalid", query));
        }
    }
}

