/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.semistructured;

import jakarta.data.Direction;
import jakarta.data.Sort;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jnosql.communication.Params;
import org.eclipse.jnosql.communication.QueryException;
import org.eclipse.jnosql.communication.query.SelectQueryConverter;
import org.eclipse.jnosql.communication.semistructured.CommunicationEntity;
import org.eclipse.jnosql.communication.semistructured.CommunicationObserverParser;
import org.eclipse.jnosql.communication.semistructured.CommunicationPreparedStatement;
import org.eclipse.jnosql.communication.semistructured.Conditions;
import org.eclipse.jnosql.communication.semistructured.CriteriaCondition;
import org.eclipse.jnosql.communication.semistructured.DatabaseManager;
import org.eclipse.jnosql.communication.semistructured.DefaultSelectQuery;
import org.eclipse.jnosql.communication.semistructured.QueryParams;
import org.eclipse.jnosql.communication.semistructured.SelectQuery;

public final class SelectQueryParser
implements BiFunction<org.eclipse.jnosql.communication.query.SelectQuery, CommunicationObserverParser, QueryParams> {
    Stream<CommunicationEntity> query(String query, DatabaseManager manager, CommunicationObserverParser observer) {
        SelectQuery selectQuery = this.getColumnQuery(query, observer);
        return manager.select(selectQuery);
    }

    CommunicationPreparedStatement prepare(String query, DatabaseManager manager, CommunicationObserverParser observer) {
        Params params = Params.newParams();
        SelectQueryConverter converter = new SelectQueryConverter();
        org.eclipse.jnosql.communication.query.DefaultSelectQuery selectQuery = converter.apply(query);
        SelectQuery columnQuery = this.getColumnQuery(params, (org.eclipse.jnosql.communication.query.SelectQuery)selectQuery, observer);
        return CommunicationPreparedStatement.select(columnQuery, params, query, manager);
    }

    @Override
    public QueryParams apply(org.eclipse.jnosql.communication.query.SelectQuery selectQuery, CommunicationObserverParser observer) {
        Objects.requireNonNull(selectQuery, "selectQuery is required");
        Objects.requireNonNull(observer, "observer is required");
        Params params = Params.newParams();
        SelectQuery columnQuery = this.getColumnQuery(params, selectQuery, observer);
        return new QueryParams(columnQuery, params);
    }

    private SelectQuery getColumnQuery(String query, CommunicationObserverParser observer) {
        SelectQueryConverter converter = new SelectQueryConverter();
        org.eclipse.jnosql.communication.query.DefaultSelectQuery selectQuery = converter.apply(query);
        String columnFamily = observer.fireEntity(selectQuery.entity());
        long limit = selectQuery.limit();
        long skip = selectQuery.skip();
        List<String> columns = selectQuery.fields().stream().map(f -> observer.fireField(columnFamily, (String)f)).collect(Collectors.toList());
        List<Sort<?>> sorts = selectQuery.orderBy().stream().map(s -> this.toSort((Sort<?>)s, observer, columnFamily)).collect(Collectors.toList());
        Params params = Params.newParams();
        CriteriaCondition condition = selectQuery.where().map(c -> Conditions.getCondition(c, params, observer, columnFamily)).orElse(null);
        if (params.isNotEmpty()) {
            throw new QueryException("To run a query with a parameter use a PrepareStatement instead.");
        }
        return new DefaultSelectQuery(limit, skip, columnFamily, columns, sorts, condition);
    }

    private SelectQuery getColumnQuery(Params params, org.eclipse.jnosql.communication.query.SelectQuery selectQuery, CommunicationObserverParser observer) {
        String columnFamily = observer.fireEntity(selectQuery.entity());
        long limit = selectQuery.limit();
        long skip = selectQuery.skip();
        List<String> columns = selectQuery.fields().stream().map(f -> observer.fireField(columnFamily, (String)f)).collect(Collectors.toList());
        List<Sort<?>> sorts = selectQuery.orderBy().stream().map(s -> this.toSort((Sort<?>)s, observer, columnFamily)).collect(Collectors.toList());
        CriteriaCondition condition = selectQuery.where().map(c -> Conditions.getCondition(c, params, observer, columnFamily)).orElse(null);
        return new DefaultSelectQuery(limit, skip, columnFamily, columns, sorts, condition);
    }

    private Sort<?> toSort(Sort<?> sort, CommunicationObserverParser observer, String entity) {
        return Sort.of((String)observer.fireField(entity, sort.property()), (Direction)(sort.isAscending() ? Direction.ASC : Direction.DESC), (boolean)false);
    }
}

