/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.semistructured;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.jnosql.communication.Params;
import org.eclipse.jnosql.communication.QueryException;
import org.eclipse.jnosql.communication.query.JSONQueryValue;
import org.eclipse.jnosql.communication.query.QueryCondition;
import org.eclipse.jnosql.communication.query.UpdateQuery;
import org.eclipse.jnosql.communication.query.UpdateQueryConverter;
import org.eclipse.jnosql.communication.semistructured.CommunicationEntity;
import org.eclipse.jnosql.communication.semistructured.CommunicationObserverParser;
import org.eclipse.jnosql.communication.semistructured.CommunicationPreparedStatement;
import org.eclipse.jnosql.communication.semistructured.ConditionQueryParser;
import org.eclipse.jnosql.communication.semistructured.ConditionQuerySupplier;
import org.eclipse.jnosql.communication.semistructured.DatabaseManager;

final class UpdateQueryParser
extends ConditionQueryParser {
    UpdateQueryParser() {
    }

    Stream<CommunicationEntity> query(String query, DatabaseManager manager, CommunicationObserverParser observer) {
        UpdateQueryConverter converter = new UpdateQueryConverter();
        UpdateQuery updateQuery = converter.apply(query);
        Params params = Params.newParams();
        CommunicationEntity entity = this.getEntity(params, updateQuery, observer);
        if (params.isNotEmpty()) {
            throw new QueryException("To run a query with a parameter use a PrepareStatement instead.");
        }
        return Stream.of(manager.update(entity));
    }

    CommunicationPreparedStatement prepare(String query, DatabaseManager manager, CommunicationObserverParser observer) {
        Params params = Params.newParams();
        UpdateQueryConverter converter = new UpdateQueryConverter();
        UpdateQuery updateQuery = converter.apply(query);
        CommunicationEntity entity = this.getEntity(params, updateQuery, observer);
        return CommunicationPreparedStatement.update(entity, params, query, manager);
    }

    private CommunicationEntity getEntity(Params params, UpdateQuery updateQuery, CommunicationObserverParser observer) {
        String columnFamily = observer.fireEntity(updateQuery.entity());
        return this.getEntity(new UpdateQueryConditionSupplier(updateQuery), columnFamily, params, observer);
    }

    private record UpdateQueryConditionSupplier(UpdateQuery query) implements ConditionQuerySupplier
    {
        @Override
        public List<QueryCondition> conditions() {
            return this.query.conditions();
        }

        @Override
        public Optional<JSONQueryValue> value() {
            return this.query.value();
        }
    }
}

