/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.semistructured;

import java.util.Arrays;
import java.util.Objects;
import org.eclipse.jnosql.communication.semistructured.CriteriaCondition;
import org.eclipse.jnosql.communication.semistructured.Element;

abstract class BaseQueryBuilder {
    protected String name;
    protected boolean negate;
    protected boolean and;
    protected CriteriaCondition condition;

    BaseQueryBuilder() {
    }

    protected <T> void eqImpl(T value) {
        Objects.requireNonNull(value, "value is required");
        CriteriaCondition newCondition = CriteriaCondition.eq(Element.of(this.name, value));
        this.appendCondition(newCondition);
    }

    protected <T> void gtImpl(T value) {
        Objects.requireNonNull(value, "value is required");
        CriteriaCondition newCondition = CriteriaCondition.gt(Element.of(this.name, value));
        this.appendCondition(newCondition);
    }

    protected void likeImpl(String value) {
        Objects.requireNonNull(value, "value is required");
        CriteriaCondition newCondition = CriteriaCondition.like(Element.of(this.name, value));
        this.appendCondition(newCondition);
    }

    protected <T> void ltImpl(T value) {
        Objects.requireNonNull(value, "value is required");
        CriteriaCondition newCondition = CriteriaCondition.lt(Element.of(this.name, value));
        this.appendCondition(newCondition);
    }

    protected <T> void lteImpl(T value) {
        Objects.requireNonNull(value, "value is required");
        CriteriaCondition newCondition = CriteriaCondition.lte(Element.of(this.name, value));
        this.appendCondition(newCondition);
    }

    protected <T> void gteImpl(T value) {
        Objects.requireNonNull(value, "value is required");
        CriteriaCondition newCondition = CriteriaCondition.gte(Element.of(this.name, value));
        this.appendCondition(newCondition);
    }

    protected <T> void betweenImpl(T valueA, T valueB) {
        Objects.requireNonNull(valueA, "valueA is required");
        Objects.requireNonNull(valueB, "valueB is required");
        CriteriaCondition newCondition = CriteriaCondition.between(Element.of(this.name, Arrays.asList(valueA, valueB)));
        this.appendCondition(newCondition);
    }

    protected <T> void inImpl(Iterable<T> values) {
        Objects.requireNonNull(values, "values is required");
        CriteriaCondition newCondition = CriteriaCondition.in(Element.of(this.name, values));
        this.appendCondition(newCondition);
    }

    protected void appendCondition(CriteriaCondition newCondition) {
        CriteriaCondition criteriaCondition = this.getColumnCondition(newCondition);
        this.condition = Objects.nonNull(this.condition) ? (this.and ? this.condition.and(criteriaCondition) : this.condition.or(criteriaCondition)) : criteriaCondition;
        this.negate = false;
        this.name = null;
    }

    private CriteriaCondition getColumnCondition(CriteriaCondition newCondition) {
        if (this.negate) {
            return newCondition.negate();
        }
        return newCondition;
    }
}

