/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.semistructured;

import org.eclipse.jnosql.communication.Condition;
import org.eclipse.jnosql.communication.Params;
import org.eclipse.jnosql.communication.QueryException;
import org.eclipse.jnosql.communication.query.ConditionQueryValue;
import org.eclipse.jnosql.communication.query.QueryCondition;
import org.eclipse.jnosql.communication.query.Where;
import org.eclipse.jnosql.communication.semistructured.CommunicationObserverParser;
import org.eclipse.jnosql.communication.semistructured.CriteriaCondition;
import org.eclipse.jnosql.communication.semistructured.Element;
import org.eclipse.jnosql.communication.semistructured.Values;

public final class Conditions {
    private Conditions() {
    }

    public static CriteriaCondition getCondition(Where where, Params params, CommunicationObserverParser observer, String entity) {
        QueryCondition condition = where.condition();
        return Conditions.getCondition(condition, params, observer, entity);
    }

    static CriteriaCondition getCondition(QueryCondition condition, Params parameters, CommunicationObserverParser observer, String entity) {
        return switch (condition.condition()) {
            case Condition.EQUALS -> CriteriaCondition.eq(Element.of(Conditions.getName(condition, observer, entity), Values.get(condition.value(), parameters)));
            case Condition.GREATER_THAN -> CriteriaCondition.gt(Element.of(Conditions.getName(condition, observer, entity), Values.get(condition.value(), parameters)));
            case Condition.GREATER_EQUALS_THAN -> CriteriaCondition.gte(Element.of(Conditions.getName(condition, observer, entity), Values.get(condition.value(), parameters)));
            case Condition.LESSER_THAN -> CriteriaCondition.lt(Element.of(Conditions.getName(condition, observer, entity), Values.get(condition.value(), parameters)));
            case Condition.LESSER_EQUALS_THAN -> CriteriaCondition.lte(Element.of(Conditions.getName(condition, observer, entity), Values.get(condition.value(), parameters)));
            case Condition.IN -> CriteriaCondition.in(Element.of(Conditions.getName(condition, observer, entity), Values.get(condition.value(), parameters)));
            case Condition.LIKE -> CriteriaCondition.like(Element.of(Conditions.getName(condition, observer, entity), Values.get(condition.value(), parameters)));
            case Condition.BETWEEN -> CriteriaCondition.between(Element.of(Conditions.getName(condition, observer, entity), Values.get(condition.value(), parameters)));
            case Condition.NOT -> Conditions.getCondition((QueryCondition)((ConditionQueryValue)ConditionQueryValue.class.cast(condition.value())).get().get(0), parameters, observer, entity).negate();
            case Condition.OR -> CriteriaCondition.or((CriteriaCondition[])((ConditionQueryValue)ConditionQueryValue.class.cast(condition.value())).get().stream().map(v -> Conditions.getCondition(v, parameters, observer, entity)).toArray(CriteriaCondition[]::new));
            case Condition.AND -> CriteriaCondition.and((CriteriaCondition[])((ConditionQueryValue)ConditionQueryValue.class.cast(condition.value())).get().stream().map(v -> Conditions.getCondition(v, parameters, observer, entity)).toArray(CriteriaCondition[]::new));
            case Condition.CONTAINS -> CriteriaCondition.contains(Element.of(Conditions.getName(condition, observer, entity), Values.get(condition.value(), parameters)));
            case Condition.STARTS_WITH -> CriteriaCondition.startsWith(Element.of(Conditions.getName(condition, observer, entity), Values.get(condition.value(), parameters)));
            case Condition.ENDS_WITH -> CriteriaCondition.endsWith(Element.of(Conditions.getName(condition, observer, entity), Values.get(condition.value(), parameters)));
            case Condition.IGNORE_CASE -> CriteriaCondition.ignoreCase(((ConditionQueryValue)ConditionQueryValue.class.cast(condition.value())).get().stream().map(v -> Conditions.getCondition(v, parameters, observer, entity)).findAny().orElseThrow());
            default -> throw new QueryException("There is not support the type: " + condition.condition());
        };
    }

    private static String getName(QueryCondition condition, CommunicationObserverParser observer, String entity) {
        return observer.fireConditionField(entity, condition.name());
    }
}

