/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.semistructured;

import jakarta.data.Sort;
import jakarta.data.page.CursoredPage;
import jakarta.data.page.PageRequest;
import jakarta.data.page.impl.CursoredPageRecord;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jnosql.communication.CommunicationException;
import org.eclipse.jnosql.communication.TypeReference;
import org.eclipse.jnosql.communication.semistructured.CommunicationEntity;
import org.eclipse.jnosql.communication.semistructured.CriteriaCondition;
import org.eclipse.jnosql.communication.semistructured.DatabaseManager;
import org.eclipse.jnosql.communication.semistructured.DefaultSelectQuery;
import org.eclipse.jnosql.communication.semistructured.Element;
import org.eclipse.jnosql.communication.semistructured.SelectQuery;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
enum CursorExecutor {
    OFF_SET{

        @Override
        public CursoredPage<CommunicationEntity> cursor(SelectQuery query, PageRequest pageRequest, DatabaseManager template) {
            CommunicationEntity last;
            DefaultSelectQuery select = new DefaultSelectQuery(pageRequest.size(), 0L, query.name(), query.columns(), query.sorts(), query.condition().orElse(null), false);
            List<CommunicationEntity> entities = template.select(select).toList();
            CommunicationEntity communicationEntity = last = entities.isEmpty() ? null : entities.get(entities.size() - 1);
            if (last == null) {
                return new CursoredPageRecord(entities, Collections.emptyList(), -1L, pageRequest, null, null);
            }
            PageRequest.Cursor cursor = CursorExecutor.getCursor(query.sorts(), last);
            PageRequest afterCursor = PageRequest.ofSize((int)pageRequest.size()).afterCursor(cursor);
            return new CursoredPageRecord(entities, List.of(cursor), -1L, pageRequest, afterCursor, null);
        }
    }
    ,
    CURSOR_NEXT{

        @Override
        public CursoredPage<CommunicationEntity> cursor(SelectQuery query, PageRequest pageRequest, DatabaseManager template) {
            CommunicationEntity last;
            PageRequest.Cursor cursor = (PageRequest.Cursor)pageRequest.cursor().orElseThrow();
            CriteriaCondition condition = 2.condition(query, cursor);
            DefaultSelectQuery select = CursorExecutor.updateQuery(pageRequest.size(), query, condition);
            List<CommunicationEntity> entities = template.select(select).toList();
            CommunicationEntity communicationEntity = last = entities.isEmpty() ? null : entities.get(entities.size() - 1);
            if (last == null) {
                return new CursoredPageRecord(entities, Collections.emptyList(), -1L, pageRequest, null, null);
            }
            PageRequest.Cursor nextCursor = CursorExecutor.getCursor(query.sorts(), last);
            PageRequest afterCursor = PageRequest.ofSize((int)pageRequest.size()).afterCursor(nextCursor);
            return new CursoredPageRecord(entities, List.of(cursor, nextCursor), -1L, pageRequest, afterCursor, null);
        }

        private static CriteriaCondition condition(SelectQuery query, PageRequest.Cursor cursor) {
            CriteriaCondition condition = null;
            CriteriaCondition previousCondition = null;
            List<Sort<?>> sorts = query.sorts();
            CursorExecutor.checkCursorKeySizes(cursor, sorts);
            for (int index = 0; index < sorts.size(); ++index) {
                Sort<?> sort = sorts.get(index);
                Object key = cursor.get(index);
                if (condition == null) {
                    condition = CriteriaCondition.gt(sort.property(), key);
                    previousCondition = CriteriaCondition.eq(sort.property(), key);
                    continue;
                }
                condition = condition.or(previousCondition.and(CriteriaCondition.gt(sort.property(), key)));
                previousCondition = previousCondition.and(CriteriaCondition.eq(sort.property(), key));
            }
            return condition;
        }
    }
    ,
    CURSOR_PREVIOUS{

        @Override
        public CursoredPage<CommunicationEntity> cursor(SelectQuery query, PageRequest pageRequest, DatabaseManager template) {
            CommunicationEntity last;
            PageRequest.Cursor cursor = (PageRequest.Cursor)pageRequest.cursor().orElseThrow();
            CriteriaCondition condition = 3.condition(query, cursor);
            DefaultSelectQuery select = CursorExecutor.updateQuery(pageRequest.size(), query, condition);
            List<CommunicationEntity> entities = template.select(select).toList();
            CommunicationEntity communicationEntity = last = entities.isEmpty() ? null : entities.get(entities.size() - 1);
            if (last == null) {
                return new CursoredPageRecord(entities, Collections.emptyList(), -1L, pageRequest, null, null);
            }
            PageRequest.Cursor beforeCursor = CursorExecutor.getCursor(query.sorts(), last);
            PageRequest beforeRequest = PageRequest.ofSize((int)pageRequest.size()).beforeCursor(beforeCursor);
            return new CursoredPageRecord(entities, List.of(beforeCursor, cursor), -1L, pageRequest, null, beforeRequest);
        }

        private static CriteriaCondition condition(SelectQuery query, PageRequest.Cursor cursor) {
            CriteriaCondition condition = null;
            CriteriaCondition previousCondition = null;
            List<Sort<?>> sorts = query.sorts();
            CursorExecutor.checkCursorKeySizes(cursor, sorts);
            for (int index = 0; index < sorts.size(); ++index) {
                Sort<?> sort = sorts.get(index);
                Object key = cursor.get(index);
                if (condition == null) {
                    condition = CriteriaCondition.lt(sort.property(), key);
                    previousCondition = CriteriaCondition.eq(sort.property(), key);
                    continue;
                }
                condition = condition.or(previousCondition.and(CriteriaCondition.lt(sort.property(), key)));
                previousCondition = previousCondition.and(CriteriaCondition.eq(sort.property(), key));
            }
            return condition;
        }
    };


    abstract CursoredPage<CommunicationEntity> cursor(SelectQuery var1, PageRequest var2, DatabaseManager var3);

    public static CursorExecutor of(PageRequest.Mode value) {
        return switch (value) {
            case PageRequest.Mode.CURSOR_NEXT -> CURSOR_NEXT;
            case PageRequest.Mode.CURSOR_PREVIOUS -> CURSOR_PREVIOUS;
            default -> OFF_SET;
        };
    }

    private static PageRequest.Cursor getCursor(List<Sort<?>> sorts, CommunicationEntity entity) {
        ArrayList<Object> keys = new ArrayList<Object>(sorts.size());
        for (Sort<?> sort : sorts) {
            String[] names = sort.property().split("\\.");
            keys.add(CursorExecutor.value(names, entity));
        }
        return PageRequest.Cursor.forKey((Object[])keys.toArray());
    }

    private static Object value(String[] names, CommunicationEntity entity) {
        Element element = entity.find(names[0]).orElseThrow(() -> new CommunicationException("The sort name does not exist in the entity: " + names[0]));
        return CursorExecutor.value(names, element, 0);
    }

    private static Object value(String[] names, Element element, int index) {
        if (names.length == 1) {
            return element.get();
        }
        List elements = (List)element.get(new TypeReference<List<Element>>(){});
        Element subElement = elements.stream().filter(e -> e.name().equals(names[index + 1])).findFirst().orElseThrow(() -> new CommunicationException("The sort name does not exist in the entity: " + names[index]));
        if (names.length == index + 2) {
            return subElement.get();
        }
        return CursorExecutor.value(names, subElement, index + 1);
    }

    private static DefaultSelectQuery updateQuery(int limit, SelectQuery query, CriteriaCondition condition) {
        return new DefaultSelectQuery(limit, 0L, query.name(), query.columns(), query.sorts(), query.condition().map(c -> CriteriaCondition.and(c, condition)).orElse(condition), false);
    }

    private static void checkCursorKeySizes(PageRequest.Cursor cursor, List<Sort<?>> sorts) {
        if (sorts.size() != cursor.size()) {
            throw new IllegalArgumentException("The cursor size is different from the sort size. Cursor: " + cursor.size() + " Sort: " + sorts.size());
        }
    }
}

