/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.semistructured;

import jakarta.data.Sort;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.jnosql.communication.semistructured.BaseQueryBuilder;
import org.eclipse.jnosql.communication.semistructured.CommunicationEntity;
import org.eclipse.jnosql.communication.semistructured.DatabaseManager;
import org.eclipse.jnosql.communication.semistructured.DefaultSelectQuery;
import org.eclipse.jnosql.communication.semistructured.SelectQuery;

class DefaultFluentSelectQueryBuilderElements
extends BaseQueryBuilder
implements SelectQuery.SelectElements,
SelectQuery.SelectFrom,
SelectQuery.SelectLimit,
SelectQuery.SelectSkip,
SelectQuery.SelectOrder,
SelectQuery.SelectNameCondition,
SelectQuery.SelectNotCondition,
SelectQuery.SelectNameOrder,
SelectQuery.SelectWhere,
SelectQuery.SelectQueryBuild {
    private String entity;
    private long skip;
    private long limit;
    private final List<Sort<?>> sorts = new ArrayList();
    private final List<String> columns;

    DefaultFluentSelectQueryBuilderElements(List<String> columns) {
        this.columns = columns;
    }

    @Override
    public SelectQuery.SelectFrom from(String entity) {
        Objects.requireNonNull(entity, "entity is required");
        this.entity = entity;
        return this;
    }

    @Override
    public SelectQuery.SelectNameCondition where(String name) {
        Objects.requireNonNull(name, "name is required");
        this.name = name;
        return this;
    }

    @Override
    public SelectQuery.SelectNameCondition and(String name) {
        Objects.requireNonNull(name, "name is required");
        this.name = name;
        this.and = true;
        return this;
    }

    @Override
    public SelectQuery.SelectNameCondition or(String name) {
        Objects.requireNonNull(name, "name is required");
        this.name = name;
        this.and = false;
        return this;
    }

    @Override
    public SelectQuery.SelectSkip skip(long skip) {
        if (skip < 0L) {
            throw new IllegalArgumentException("The skip should not be negative, skip: " + skip);
        }
        this.skip = skip;
        return this;
    }

    @Override
    public SelectQuery.SelectLimit limit(long limit) {
        if (limit < 0L) {
            throw new IllegalArgumentException("The limit should not be negative, limit: " + limit);
        }
        this.limit = limit;
        return this;
    }

    @Override
    public SelectQuery.SelectOrder orderBy(String name) {
        Objects.requireNonNull(name, "name is required");
        this.name = name;
        return this;
    }

    @Override
    public SelectQuery.SelectNotCondition not() {
        this.negate = true;
        return this;
    }

    @Override
    public <T> SelectQuery.SelectWhere eq(T value) {
        this.eqImpl(value);
        return this;
    }

    @Override
    public SelectQuery.SelectWhere like(String value) {
        this.likeImpl(value);
        return this;
    }

    @Override
    public <T> SelectQuery.SelectWhere gt(T value) {
        this.gtImpl(value);
        return this;
    }

    @Override
    public <T> SelectQuery.SelectWhere gte(T value) {
        this.gteImpl(value);
        return this;
    }

    @Override
    public <T> SelectQuery.SelectWhere lt(T value) {
        this.ltImpl(value);
        return this;
    }

    @Override
    public <T> SelectQuery.SelectWhere lte(T value) {
        this.lteImpl(value);
        return this;
    }

    @Override
    public <T> SelectQuery.SelectWhere between(T valueA, T valueB) {
        this.betweenImpl(valueA, valueB);
        return this;
    }

    @Override
    public <T> SelectQuery.SelectWhere in(Iterable<T> values) {
        this.inImpl(values);
        return this;
    }

    @Override
    public SelectQuery.SelectNameOrder asc() {
        this.sorts.add(Sort.asc((String)this.name));
        return this;
    }

    @Override
    public SelectQuery.SelectNameOrder desc() {
        this.sorts.add(Sort.desc((String)this.name));
        return this;
    }

    @Override
    public SelectQuery build() {
        return new DefaultSelectQuery(this.limit, this.skip, this.entity, this.columns, this.sorts, this.condition, false);
    }

    @Override
    public Stream<CommunicationEntity> getResult(DatabaseManager manager) {
        Objects.requireNonNull(manager, "manager is required");
        return manager.select(this.build());
    }

    @Override
    public Optional<CommunicationEntity> getSingleResult(DatabaseManager manager) {
        Objects.requireNonNull(manager, "manager is required");
        return manager.singleResult(this.build());
    }
}

