/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.semistructured;

import jakarta.data.Sort;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.eclipse.jnosql.communication.semistructured.CommunicationEntity;
import org.eclipse.jnosql.communication.semistructured.CriteriaCondition;
import org.eclipse.jnosql.communication.semistructured.DatabaseManager;
import org.eclipse.jnosql.communication.semistructured.DefaultSelectQuery;
import org.eclipse.jnosql.communication.semistructured.SelectQuery;

class DefaultQueryBuilder
implements SelectQuery.QueryBuilder {
    private final List<String> columns = new ArrayList<String>();
    private final List<Sort<?>> sorts = new ArrayList();
    private String entity;
    private CriteriaCondition condition;
    private long skip;
    private long limit;

    DefaultQueryBuilder() {
    }

    @Override
    public SelectQuery.QueryBuilder select(String column) {
        Objects.requireNonNull(column, "column is required");
        this.columns.add(column);
        return this;
    }

    @Override
    public SelectQuery.QueryBuilder select(String ... columns) {
        Consumer<String> validNull = d -> Objects.requireNonNull(d, "there is null column in the query");
        Consumer<String> consume = this.columns::add;
        Stream.of(columns).forEach(validNull.andThen(consume));
        return this;
    }

    @Override
    public SelectQuery.QueryBuilder sort(Sort<?> sort) {
        Objects.requireNonNull(sort, "sort is required");
        this.sorts.add(sort);
        return this;
    }

    @Override
    public SelectQuery.QueryBuilder sort(Sort<?> ... sorts) {
        Consumer<Sort> validNull = d -> Objects.requireNonNull(d, "there is null document in the query");
        Consumer<Sort> consume = this.sorts::add;
        Stream.of(sorts).forEach(validNull.andThen(consume));
        return this;
    }

    @Override
    public SelectQuery.QueryBuilder from(String entity) {
        Objects.requireNonNull(entity, "entity is required");
        this.entity = entity;
        return this;
    }

    @Override
    public SelectQuery.QueryBuilder where(CriteriaCondition condition) {
        Objects.requireNonNull(condition, "condition is required");
        this.condition = condition;
        return this;
    }

    @Override
    public SelectQuery.QueryBuilder skip(long skip) {
        if (skip < 0L) {
            throw new IllegalArgumentException("The skip should not be negative, skip: " + skip);
        }
        this.skip = skip;
        return this;
    }

    @Override
    public SelectQuery.QueryBuilder limit(long limit) {
        if (limit < 0L) {
            throw new IllegalArgumentException("The limit should not be negative, limit: " + limit);
        }
        this.limit = limit;
        return this;
    }

    @Override
    public SelectQuery build() {
        if (Objects.isNull(this.entity)) {
            throw new IllegalArgumentException("The document collection is mandatory to build");
        }
        return new DefaultSelectQuery(this.limit, this.skip, this.entity, this.columns, this.sorts, this.condition, false);
    }

    @Override
    public Stream<CommunicationEntity> getResult(DatabaseManager manager) {
        Objects.requireNonNull(manager, "manager is required");
        return manager.select(this.build());
    }

    @Override
    public Optional<CommunicationEntity> getSingleResult(DatabaseManager manager) {
        Objects.requireNonNull(manager, "manager is required");
        return manager.singleResult(this.build());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultQueryBuilder that = (DefaultQueryBuilder)o;
        return this.skip == that.skip && this.limit == that.limit && Objects.equals(this.columns, that.columns) && Objects.equals(this.sorts, that.sorts) && Objects.equals(this.entity, that.entity) && Objects.equals(this.condition, that.condition);
    }

    public int hashCode() {
        return Objects.hash(this.columns, this.sorts, this.entity, this.condition, this.skip, this.limit);
    }

    public String toString() {
        return "DefaultColumnQueryBuilder{columns=" + this.columns + ", sorts=" + this.sorts + ", entity='" + this.entity + "', condition=" + this.condition + ", skip=" + this.skip + ", limit=" + this.limit + "}";
    }
}

