/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.semistructured;

import java.util.Objects;

public enum QueryType {
    SELECT,
    DELETE,
    UPDATE;


    public static QueryType parse(String query) {
        String command;
        Objects.requireNonNull(query, "Query string cannot be null");
        return switch (command = QueryType.extractQueryCommand(query)) {
            case "DELETE" -> DELETE;
            case "UPDATE" -> UPDATE;
            default -> SELECT;
        };
    }

    public boolean isNotSelect() {
        return this != SELECT;
    }

    public void checkValidReturn(Class<?> returnType, String query) {
        if (this.isNotSelect() && !this.isVoid(returnType)) {
            throw new UnsupportedOperationException("The return type must be Void when the query is not a SELECT operation, due to the nature of DELETE and UPDATE operations. The query: " + query);
        }
    }

    private boolean isVoid(Class<?> returnType) {
        return returnType == Void.class || returnType == Void.TYPE;
    }

    private static String extractQueryCommand(String query) {
        if (query.length() < 6) {
            return "";
        }
        return query.substring(0, 6).toUpperCase();
    }
}

