/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.semistructured;

import jakarta.data.Sort;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.eclipse.jnosql.communication.semistructured.CommunicationEntity;
import org.eclipse.jnosql.communication.semistructured.CriteriaCondition;
import org.eclipse.jnosql.communication.semistructured.DatabaseManager;
import org.eclipse.jnosql.communication.semistructured.DefaultFluentSelectQueryBuilderElements;
import org.eclipse.jnosql.communication.semistructured.DefaultQueryBuilder;

public interface SelectQuery {
    public long limit();

    public long skip();

    public String name();

    public Optional<CriteriaCondition> condition();

    public List<String> columns();

    public List<Sort<?>> sorts();

    default public boolean isCount() {
        return false;
    }

    public static SelectElements select(String ... names) {
        Stream.of(names).forEach(d -> Objects.requireNonNull(d, "A document in the query is null"));
        return new DefaultFluentSelectQueryBuilderElements(Arrays.asList(names));
    }

    public static SelectElements select() {
        return new DefaultFluentSelectQueryBuilderElements(Collections.emptyList());
    }

    public static QueryBuilder builder() {
        return new DefaultQueryBuilder();
    }

    public static QueryBuilder builder(String ... names) {
        Stream.of(names).forEach(d -> Objects.requireNonNull(d, "A column in the query is null"));
        DefaultQueryBuilder builder = new DefaultQueryBuilder();
        Stream.of(names).forEach(builder::select);
        return builder;
    }

    public static interface QueryBuilder {
        public QueryBuilder select(String var1);

        public QueryBuilder select(String ... var1);

        public QueryBuilder sort(Sort<?> var1);

        public QueryBuilder sort(Sort<?> ... var1);

        public QueryBuilder from(String var1);

        public QueryBuilder where(CriteriaCondition var1);

        public QueryBuilder skip(long var1);

        public QueryBuilder limit(long var1);

        public SelectQuery build();

        public Stream<CommunicationEntity> getResult(DatabaseManager var1);

        public Optional<CommunicationEntity> getSingleResult(DatabaseManager var1);
    }

    public static interface SelectNotCondition
    extends SelectNameCondition {
    }

    public static interface SelectNameCondition {
        public <T> SelectWhere eq(T var1);

        public SelectWhere like(String var1);

        public <T> SelectWhere gt(T var1);

        public <T> SelectWhere gte(T var1);

        public <T> SelectWhere lt(T var1);

        public <T> SelectWhere lte(T var1);

        public <T> SelectWhere between(T var1, T var2);

        public <T> SelectWhere in(Iterable<T> var1);

        public SelectNotCondition not();
    }

    public static interface SelectWhere
    extends SelectQueryBuild {
        public SelectNameCondition and(String var1);

        public SelectNameCondition or(String var1);

        public SelectSkip skip(long var1);

        public SelectLimit limit(long var1);

        public SelectOrder orderBy(String var1);
    }

    public static interface SelectSkip
    extends SelectQueryBuild {
        public SelectLimit limit(long var1);
    }

    public static interface QueryBuilderProvider
    extends Function<String[], QueryBuilder>,
    Supplier<QueryBuilder> {
    }

    public static interface SelectProvider
    extends Function<String[], SelectElements>,
    Supplier<SelectElements> {
    }

    public static interface SelectElements {
        public SelectFrom from(String var1);
    }

    public static interface SelectQueryBuild {
        public SelectQuery build();

        public Stream<CommunicationEntity> getResult(DatabaseManager var1);

        public Optional<CommunicationEntity> getSingleResult(DatabaseManager var1);
    }

    public static interface SelectOrder {
        public SelectNameOrder asc();

        public SelectNameOrder desc();
    }

    public static interface SelectNameOrder
    extends SelectQueryBuild {
        public SelectOrder orderBy(String var1);

        public SelectSkip skip(long var1);

        public SelectLimit limit(long var1);
    }

    public static interface SelectLimit
    extends SelectQueryBuild {
        public SelectSkip skip(long var1);
    }

    public static interface SelectFrom
    extends SelectQueryBuild {
        public SelectNameCondition where(String var1);

        public SelectSkip skip(long var1);

        public SelectLimit limit(long var1);

        public SelectOrder orderBy(String var1);
    }
}

