/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.semistructured;

import java.util.ArrayList;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.jnosql.communication.Params;
import org.eclipse.jnosql.communication.QueryException;
import org.eclipse.jnosql.communication.query.UpdateItem;
import org.eclipse.jnosql.communication.query.data.UpdateProvider;
import org.eclipse.jnosql.communication.semistructured.CommunicationEntity;
import org.eclipse.jnosql.communication.semistructured.CommunicationObserverParser;
import org.eclipse.jnosql.communication.semistructured.CommunicationPreparedStatement;
import org.eclipse.jnosql.communication.semistructured.Conditions;
import org.eclipse.jnosql.communication.semistructured.CriteriaCondition;
import org.eclipse.jnosql.communication.semistructured.DatabaseManager;
import org.eclipse.jnosql.communication.semistructured.DefaultUpdateQuery;
import org.eclipse.jnosql.communication.semistructured.Element;
import org.eclipse.jnosql.communication.semistructured.UpdateQuery;
import org.eclipse.jnosql.communication.semistructured.UpdateQueryParams;
import org.eclipse.jnosql.communication.semistructured.Values;

public final class UpdateQueryParser
implements BiFunction<org.eclipse.jnosql.communication.query.UpdateQuery, CommunicationObserverParser, UpdateQueryParams> {
    Stream<CommunicationEntity> query(String query, DatabaseManager manager, CommunicationObserverParser observer) {
        UpdateQuery updateQuery = this.getQuery(query, observer);
        return StreamSupport.stream(manager.update(updateQuery).spliterator(), false);
    }

    CommunicationPreparedStatement prepare(String query, DatabaseManager manager, CommunicationObserverParser observer) {
        Params params = Params.newParams();
        UpdateQuery updateQuery = this.getQuery(query, params, observer);
        return CommunicationPreparedStatement.update(updateQuery, params, query, manager);
    }

    @Override
    public UpdateQueryParams apply(org.eclipse.jnosql.communication.query.UpdateQuery updateQuery, CommunicationObserverParser communicationObserverParser) {
        Objects.requireNonNull(updateQuery, "updateQuery is required");
        Objects.requireNonNull(communicationObserverParser, "columnObserverParser is required");
        Params params = Params.newParams();
        UpdateQuery query = this.getQuery(params, communicationObserverParser, updateQuery);
        return new UpdateQueryParams(query, params);
    }

    private UpdateQuery getQuery(String query, Params params, CommunicationObserverParser observer) {
        org.eclipse.jnosql.communication.query.UpdateQuery updateQuery = UpdateProvider.INSTANCE.apply(query);
        return this.getQuery(params, observer, updateQuery);
    }

    private UpdateQuery getQuery(Params params, CommunicationObserverParser observer, org.eclipse.jnosql.communication.query.UpdateQuery updateQuery) {
        String entity = observer.fireEntity(updateQuery.entity());
        ArrayList<Element> set = new ArrayList<Element>();
        for (UpdateItem updateItem : updateQuery.set()) {
            String field = observer.fireSelectField(entity, updateItem.name());
            Object value = Values.get(updateItem.value(), params);
            set.add(Element.of(field, value));
        }
        CriteriaCondition condition = updateQuery.where().map(c -> Conditions.getCondition(c, params, observer, entity)).orElse(null);
        return new DefaultUpdateQuery(entity, set, condition);
    }

    private UpdateQuery getQuery(String query, CommunicationObserverParser observer) {
        org.eclipse.jnosql.communication.query.UpdateQuery updateQuery = UpdateProvider.INSTANCE.apply(query);
        String entity = observer.fireEntity(updateQuery.entity());
        Params params = Params.newParams();
        ArrayList<Element> set = new ArrayList<Element>();
        for (UpdateItem updateItem : updateQuery.set()) {
            String field = observer.fireSelectField(entity, updateItem.name());
            Object value = Values.get(updateItem.value(), params);
            set.add(Element.of(field, value));
        }
        CriteriaCondition condition = updateQuery.where().map(c -> Conditions.getCondition(c, params, observer, entity)).orElse(null);
        if (params.isNotEmpty()) {
            throw new QueryException("To run a query with a parameter use a PrepareStatement instead.");
        }
        return new DefaultUpdateQuery(entity, set, condition);
    }
}

