/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.semistructured;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jnosql.communication.Params;
import org.eclipse.jnosql.communication.QueryException;
import org.eclipse.jnosql.communication.query.ArrayQueryValue;
import org.eclipse.jnosql.communication.query.EnumQueryValue;
import org.eclipse.jnosql.communication.query.ParamQueryValue;
import org.eclipse.jnosql.communication.query.QueryValue;
import org.eclipse.jnosql.communication.query.ValueType;

final class Values {
    private Values() {
    }

    static Object get(QueryValue<?> value, Params parameters) {
        ValueType type = value.type();
        switch (type) {
            case NUMBER: 
            case STRING: 
            case BOOLEAN: {
                return value.get();
            }
            case PARAMETER: {
                return parameters.add((String)((ParamQueryValue)value).get());
            }
            case ARRAY: {
                return Stream.of((QueryValue[])((ArrayQueryValue)value).get()).map(v -> Values.get(v, parameters)).collect(Collectors.toList());
            }
            case ENUM: {
                return ((EnumQueryValue)value).get().name();
            }
            case NULL: {
                return null;
            }
        }
        throw new QueryException("There is not support to the value: " + type);
    }
}

