/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.semistructured;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jnosql.communication.Entry;
import org.eclipse.jnosql.communication.TypeSupplier;
import org.eclipse.jnosql.communication.Value;
import org.eclipse.jnosql.communication.semistructured.Element;

public class CommunicationEntity {
    private final Map<String, Element> elements = new HashMap<String, Element>();
    private final String name;

    CommunicationEntity(String name) {
        this.name = name;
    }

    public void addAll(List<Element> elements) {
        Objects.requireNonNull(elements, "The object column is required");
        elements.forEach(this::add);
    }

    public void add(Element element) {
        Objects.requireNonNull(element, "Column is required");
        this.elements.put(element.name(), element);
    }

    public void add(String name, Object value) {
        Objects.requireNonNull(name, "name is required");
        this.elements.put(name, Element.of(name, Value.of((Object)value)));
    }

    public void add(String name, Value value) {
        Objects.requireNonNull(name, "name is required");
        this.elements.put(name, Element.of(name, value));
    }

    public void addNull(String name) {
        Objects.requireNonNull(name, "name is required");
        this.elements.put(name, Element.of(name, Value.ofNull()));
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry<String, Element> entry : this.elements.entrySet()) {
            Element element = entry.getValue();
            map.put(entry.getKey(), this.convert(element.get()));
        }
        return Collections.unmodifiableMap(map);
    }

    public List<Element> elements() {
        return this.elements.values().stream().collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    public String name() {
        return this.name;
    }

    public boolean remove(String name) {
        Objects.requireNonNull(name, "name is required");
        return this.elements.remove(name) != null;
    }

    public Optional<Element> find(String columnName) {
        Objects.requireNonNull(columnName, "columnName is required");
        Element element = this.elements.get(columnName);
        return Optional.ofNullable(element);
    }

    public <T> Optional<T> find(String elementName, Class<T> type) {
        Objects.requireNonNull(elementName, "elementName is required");
        Objects.requireNonNull(type, "type is required");
        return Optional.ofNullable(this.elements.get(elementName)).map(c -> c.get(type));
    }

    public <T> Optional<T> find(String elementName, TypeSupplier<T> type) {
        Objects.requireNonNull(elementName, "elementName is required");
        Objects.requireNonNull(type, "type is required");
        return Optional.ofNullable(this.elements.get(elementName)).map(v -> v.get(type));
    }

    public int size() {
        return this.elements.size();
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public CommunicationEntity copy() {
        CommunicationEntity entity = new CommunicationEntity(this.name);
        entity.elements.putAll(new HashMap<String, Element>(this.elements));
        return entity;
    }

    public Set<String> elementNames() {
        return Collections.unmodifiableSet(this.elements.keySet());
    }

    public Collection<Value> values() {
        return this.elements.values().stream().map(Entry::value).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    public boolean contains(String name) {
        Objects.requireNonNull(name, "name is required");
        return this.elements.containsKey(name);
    }

    public void clear() {
        this.elements.clear();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommunicationEntity that = (CommunicationEntity)o;
        return Objects.equals(this.elements, that.elements) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.elements, this.name);
    }

    public String toString() {
        return "DefaultColumnEntity{columns=" + this.toMap() + ", name='" + this.name + "'}";
    }

    public static CommunicationEntity of(String name) {
        return new CommunicationEntity(Objects.requireNonNull(name, "name is required"));
    }

    public static CommunicationEntity of(String name, List<Element> elements) {
        CommunicationEntity communicationEntity = new CommunicationEntity(name);
        communicationEntity.addAll(elements);
        return communicationEntity;
    }

    private Object convert(Object value) {
        if (value instanceof Element) {
            Element element = (Element)Element.class.cast(value);
            return Collections.singletonMap(element.name(), this.convert(element.get()));
        }
        if (value instanceof Iterable) {
            ArrayList list = new ArrayList();
            ((Iterable)Iterable.class.cast(value)).forEach(e -> list.add(this.convert(e)));
            return list;
        }
        return value;
    }
}

