/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.semistructured;

import jakarta.data.exceptions.NonUniqueResultException;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.jnosql.communication.Params;
import org.eclipse.jnosql.communication.QueryException;
import org.eclipse.jnosql.communication.semistructured.CommunicationEntity;
import org.eclipse.jnosql.communication.semistructured.DatabaseManager;
import org.eclipse.jnosql.communication.semistructured.DeleteQuery;
import org.eclipse.jnosql.communication.semistructured.SelectQuery;
import org.eclipse.jnosql.communication.semistructured.UpdateQuery;

public final class CommunicationPreparedStatement {
    private static final UnaryOperator<SelectQuery> SELECT_MAPPER_DEFAULT = s -> s;
    private final SelectQuery selectQuery;
    private final DeleteQuery deleteQuery;
    private final UpdateQuery updateQuery;
    private final PreparedStatementType type;
    private final Params params;
    private final String query;
    private final List<String> paramsLeft;
    private final DatabaseManager manager;
    private UnaryOperator<SelectQuery> selectMapper = SELECT_MAPPER_DEFAULT;

    private CommunicationPreparedStatement(SelectQuery selectQuery, DeleteQuery deleteQuery, UpdateQuery updateQuery, PreparedStatementType type, Params params, String query, List<String> paramsLeft, DatabaseManager manager) {
        this.selectQuery = selectQuery;
        this.deleteQuery = deleteQuery;
        this.updateQuery = updateQuery;
        this.type = type;
        this.params = params;
        this.query = query;
        this.paramsLeft = paramsLeft;
        this.manager = manager;
    }

    public CommunicationPreparedStatement bind(String name, Object value) {
        Objects.requireNonNull(name, "name is required");
        Objects.requireNonNull(value, "value is required");
        this.paramsLeft.remove(name);
        this.params.bind(name, value);
        return this;
    }

    public CommunicationPreparedStatement bind(int index, Object value) {
        Objects.requireNonNull(value, "value is required");
        if (index < 1) {
            throw new IllegalArgumentException("The index should be greater than zero");
        }
        String name = "?" + index;
        this.paramsLeft.remove("?" + index);
        this.params.bind(name, value);
        return this;
    }

    public Optional<SelectQuery> select() {
        return Optional.ofNullable(this.selectQuery);
    }

    public Stream<CommunicationEntity> result() {
        if (!this.paramsLeft.isEmpty()) {
            throw new QueryException("Check all the parameters before execute the query, params left: " + this.paramsLeft);
        }
        switch (this.type) {
            case SELECT: {
                return this.manager.select((SelectQuery)this.operator().apply(this.selectQuery));
            }
            case DELETE: {
                this.manager.delete(this.deleteQuery);
                return Stream.empty();
            }
            case UPDATE: {
                return StreamSupport.stream(this.manager.update(this.updateQuery).spliterator(), false);
            }
        }
        throw new UnsupportedOperationException("there is not support to operation type: " + this.type);
    }

    public UnaryOperator<SelectQuery> operator() {
        return this.selectMapper;
    }

    public void setSelectMapper(UnaryOperator<SelectQuery> selectMapper) {
        Objects.requireNonNull(selectMapper, "selectMapper is required");
        this.selectMapper = selectMapper;
    }

    public long count() {
        if (!this.paramsLeft.isEmpty()) {
            throw new QueryException("Check all the parameters before execute the query, params left: " + this.paramsLeft);
        }
        if (PreparedStatementType.COUNT.equals((Object)this.type)) {
            return this.manager.count(this.selectQuery);
        }
        throw new IllegalArgumentException("The count operation is only allowed for COUNT queries");
    }

    public Optional<CommunicationEntity> singleResult() {
        Stream<CommunicationEntity> entities = this.result();
        Iterator iterator = entities.iterator();
        if (!iterator.hasNext()) {
            return Optional.empty();
        }
        CommunicationEntity next = (CommunicationEntity)iterator.next();
        if (!iterator.hasNext()) {
            return Optional.of(next);
        }
        throw new NonUniqueResultException("The select returns more than one entity, select: " + this.query);
    }

    public String toString() {
        return this.query;
    }

    static CommunicationPreparedStatement select(SelectQuery selectQuery, Params params, String query, DatabaseManager manager) {
        if (selectQuery.isCount()) {
            return new CommunicationPreparedStatement(selectQuery, null, null, PreparedStatementType.COUNT, params, query, params.getParametersNames(), manager);
        }
        return new CommunicationPreparedStatement(selectQuery, null, null, PreparedStatementType.SELECT, params, query, params.getParametersNames(), manager);
    }

    static CommunicationPreparedStatement delete(DeleteQuery deleteQuery, Params params, String query, DatabaseManager manager) {
        return new CommunicationPreparedStatement(null, deleteQuery, null, PreparedStatementType.DELETE, params, query, params.getParametersNames(), manager);
    }

    static CommunicationPreparedStatement update(UpdateQuery updateQuery, Params params, String query, DatabaseManager manager) {
        return new CommunicationPreparedStatement(null, null, updateQuery, PreparedStatementType.UPDATE, params, query, params.getParametersNames(), manager);
    }

    static enum PreparedStatementType {
        SELECT,
        DELETE,
        UPDATE,
        COUNT;

    }
}

