/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.semistructured;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.StreamSupport;
import org.eclipse.jnosql.communication.Condition;
import org.eclipse.jnosql.communication.TypeReference;
import org.eclipse.jnosql.communication.Value;
import org.eclipse.jnosql.communication.semistructured.Element;

public final class CriteriaCondition {
    private final Element element;
    private final Condition condition;
    private final boolean readOnly;

    private CriteriaCondition(Element element, Condition condition) {
        this.element = element;
        this.condition = condition;
        this.readOnly = false;
    }

    private CriteriaCondition(Element element, Condition condition, boolean readOnly) {
        this.element = element;
        this.condition = condition;
        this.readOnly = readOnly;
    }

    public Element element() {
        return this.element;
    }

    public Condition condition() {
        return this.condition;
    }

    public CriteriaCondition and(CriteriaCondition condition) {
        this.validateReadOnly();
        Objects.requireNonNull(condition, "Conditions are required");
        if (Condition.AND.equals((Object)this.condition)) {
            Element newElement = this.getConditions(condition, Condition.AND);
            return new CriteriaCondition(newElement, Condition.AND);
        }
        return CriteriaCondition.and(this, condition);
    }

    public CriteriaCondition negate() {
        this.validateReadOnly();
        if (Condition.NOT.equals((Object)this.condition)) {
            return this.element.get(CriteriaCondition.class);
        }
        Element newElement = Element.of(Condition.NOT.getNameField(), this);
        return new CriteriaCondition(newElement, Condition.NOT);
    }

    public CriteriaCondition or(CriteriaCondition condition) {
        this.validateReadOnly();
        Objects.requireNonNull(condition, "Condition is required");
        if (Condition.OR.equals((Object)this.condition)) {
            Element newElement = this.getConditions(condition, Condition.OR);
            return new CriteriaCondition(newElement, Condition.OR);
        }
        return CriteriaCondition.or(this, condition);
    }

    private Element getConditions(CriteriaCondition criteriaCondition, Condition condition) {
        ArrayList<CriteriaCondition> conditions = new ArrayList<CriteriaCondition>((Collection)this.element.get(new TypeReference<List<CriteriaCondition>>(){}));
        conditions.add(criteriaCondition);
        return Element.of(condition.getNameField(), conditions);
    }

    private void validateReadOnly() {
        if (this.readOnly) {
            throw new IllegalStateException("You cannot change the status after building the query");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CriteriaCondition that = (CriteriaCondition)o;
        return Objects.equals(this.element, that.element) && this.condition == that.condition;
    }

    public int hashCode() {
        return Objects.hash(this.element, this.condition, this.readOnly);
    }

    public String toString() {
        return "CriteriaCondition{element=" + this.element + ", condition=" + this.condition + "}";
    }

    public static CriteriaCondition readOnly(CriteriaCondition condition) {
        Objects.requireNonNull(condition, "Condition is required");
        return new CriteriaCondition(condition.element(), condition.condition(), true);
    }

    static CriteriaCondition of(Element element, Condition condition) {
        return new CriteriaCondition(Objects.requireNonNull(element, "Column is required"), condition);
    }

    public static CriteriaCondition eq(Element element) {
        return new CriteriaCondition(element, Condition.EQUALS);
    }

    public static CriteriaCondition eq(String name, Object value) {
        Objects.requireNonNull(name, "Name is required");
        Objects.requireNonNull(value, "Value is required");
        return CriteriaCondition.eq(Element.of(name, value));
    }

    public static CriteriaCondition gt(Element element) {
        return new CriteriaCondition(element, Condition.GREATER_THAN);
    }

    public static CriteriaCondition gt(String name, Object value) {
        Objects.requireNonNull(name, "Name is required");
        Objects.requireNonNull(value, "Value is required");
        return CriteriaCondition.gt(Element.of(name, value));
    }

    public static CriteriaCondition gte(Element element) {
        return new CriteriaCondition(element, Condition.GREATER_EQUALS_THAN);
    }

    public static CriteriaCondition gte(String name, Object value) {
        Objects.requireNonNull(name, "Name is required");
        Objects.requireNonNull(value, "Value is required");
        return CriteriaCondition.gte(Element.of(name, value));
    }

    public static CriteriaCondition lt(Element element) {
        return new CriteriaCondition(element, Condition.LESSER_THAN);
    }

    public static CriteriaCondition lt(String name, Object value) {
        Objects.requireNonNull(name, "Name is required");
        Objects.requireNonNull(value, "Value is required");
        return CriteriaCondition.lt(Element.of(name, value));
    }

    public static CriteriaCondition lte(Element element) {
        return new CriteriaCondition(element, Condition.LESSER_EQUALS_THAN);
    }

    public static CriteriaCondition lte(String name, Object value) {
        Objects.requireNonNull(name, "Name is required");
        Objects.requireNonNull(value, "Value is required");
        return CriteriaCondition.lte(Element.of(name, value));
    }

    public static CriteriaCondition in(Element element) {
        Objects.requireNonNull(element, "element is required");
        CriteriaCondition.checkInClause(element.value());
        return new CriteriaCondition(element, Condition.IN);
    }

    public static CriteriaCondition in(String name, Object value) {
        Objects.requireNonNull(name, "Name is required");
        Objects.requireNonNull(value, "Value is required");
        return CriteriaCondition.in(Element.of(name, value));
    }

    public static CriteriaCondition like(Element element) {
        return new CriteriaCondition(element, Condition.LIKE);
    }

    public static CriteriaCondition like(String name, Object value) {
        Objects.requireNonNull(name, "Name is required");
        Objects.requireNonNull(value, "Value is required");
        return CriteriaCondition.like(Element.of(name, value));
    }

    public static CriteriaCondition between(Element element) {
        Objects.requireNonNull(element, "element is required");
        CriteriaCondition.checkBetweenClause(element.get());
        return new CriteriaCondition(element, Condition.BETWEEN);
    }

    public static CriteriaCondition between(String name, Object value) {
        Objects.requireNonNull(name, "Name is required");
        Objects.requireNonNull(value, "Value is required");
        return CriteriaCondition.between(Element.of(name, value));
    }

    public static CriteriaCondition not(CriteriaCondition condition) {
        Objects.requireNonNull(condition, "Condition is required");
        return condition.negate();
    }

    public static CriteriaCondition and(CriteriaCondition ... conditions) {
        Objects.requireNonNull(conditions, "Condition is required");
        Element element = Element.of(Condition.AND.getNameField(), Arrays.asList(conditions));
        return CriteriaCondition.of(element, Condition.AND);
    }

    public static CriteriaCondition or(CriteriaCondition ... conditions) {
        Objects.requireNonNull(conditions, "Condition is required");
        Element element = Element.of(Condition.OR.getNameField(), Arrays.asList(conditions));
        return CriteriaCondition.of(element, Condition.OR);
    }

    private static void checkInClause(Value value) {
        if (!value.isInstanceOf(Iterable.class)) {
            throw new IllegalArgumentException("On CriteriaCondition#in, you must use an iterable instead of class: " + value.getClass().getName());
        }
    }

    private static void checkBetweenClause(Object value) {
        if (Iterable.class.isInstance(value)) {
            long count = StreamSupport.stream(((Iterable)Iterable.class.cast(value)).spliterator(), false).count();
            if (count != 2L) {
                throw new IllegalArgumentException("On CriteriaCondition#between, you must use an iterable with two elements");
            }
        } else {
            throw new IllegalArgumentException("On CriteriaCondition#between, you must use an iterable with two elements instead of class: " + value.getClass().getName());
        }
    }
}

