/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.semistructured;

import jakarta.data.exceptions.NonUniqueResultException;
import jakarta.data.page.CursoredPage;
import jakarta.data.page.PageRequest;
import java.time.Duration;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.jnosql.communication.semistructured.CommunicationEntity;
import org.eclipse.jnosql.communication.semistructured.CommunicationObserverParser;
import org.eclipse.jnosql.communication.semistructured.CommunicationPreparedStatement;
import org.eclipse.jnosql.communication.semistructured.CursorExecutor;
import org.eclipse.jnosql.communication.semistructured.DefaultSelectQuery;
import org.eclipse.jnosql.communication.semistructured.DeleteQuery;
import org.eclipse.jnosql.communication.semistructured.QueryParser;
import org.eclipse.jnosql.communication.semistructured.SelectQuery;
import org.eclipse.jnosql.communication.semistructured.UpdateQuery;

public interface DatabaseManager
extends AutoCloseable {
    public String name();

    public CommunicationEntity insert(CommunicationEntity var1);

    public CommunicationEntity insert(CommunicationEntity var1, Duration var2);

    public Iterable<CommunicationEntity> insert(Iterable<CommunicationEntity> var1);

    public Iterable<CommunicationEntity> insert(Iterable<CommunicationEntity> var1, Duration var2);

    public CommunicationEntity update(CommunicationEntity var1);

    public Iterable<CommunicationEntity> update(Iterable<CommunicationEntity> var1);

    default public Iterable<CommunicationEntity> update(UpdateQuery query) {
        Objects.requireNonNull(query, "query is required");
        Stream<CommunicationEntity> entities = this.select(query.toSelectQuery());
        return entities.peek(e -> e.addAll(query.set())).map(this::update).toList();
    }

    public void delete(DeleteQuery var1);

    public Stream<CommunicationEntity> select(SelectQuery var1);

    default public long count(SelectQuery query) {
        Objects.requireNonNull(query, "query is required");
        return this.select(DefaultSelectQuery.countBy(query)).count();
    }

    default public boolean exists(SelectQuery query) {
        Objects.requireNonNull(query, "query is required");
        return this.select(DefaultSelectQuery.existsBy(query)).findAny().isPresent();
    }

    default public Stream<CommunicationEntity> query(String query) {
        return this.query(query, null);
    }

    default public Stream<CommunicationEntity> query(String query, String entity) {
        Objects.requireNonNull(query, "query is required");
        QueryParser parser = new QueryParser();
        return parser.query(query, entity, this, CommunicationObserverParser.EMPTY);
    }

    default public CommunicationPreparedStatement prepare(String query) {
        return this.prepare(query, null);
    }

    default public CommunicationPreparedStatement prepare(String query, String entity) {
        Objects.requireNonNull(query, "query is required");
        QueryParser parser = new QueryParser();
        return parser.prepare(query, entity, this, CommunicationObserverParser.EMPTY);
    }

    default public Optional<CommunicationEntity> singleResult(SelectQuery query) {
        Objects.requireNonNull(query, "query is required");
        Stream<CommunicationEntity> entities = this.select(query);
        Iterator iterator = entities.iterator();
        if (!iterator.hasNext()) {
            return Optional.empty();
        }
        CommunicationEntity entity = (CommunicationEntity)iterator.next();
        if (!iterator.hasNext()) {
            return Optional.of(entity);
        }
        throw new NonUniqueResultException("More than one entity was returned by the query: " + query);
    }

    default public CursoredPage<CommunicationEntity> selectCursor(SelectQuery query, PageRequest pageRequest) {
        Objects.requireNonNull(query, "query is required");
        Objects.requireNonNull(pageRequest, "pageRequest is required");
        if (query.sorts().isEmpty()) {
            throw new IllegalArgumentException("To execute a cursor pagination, it is necessary to define at least one sort field." + query);
        }
        CursorExecutor executor = CursorExecutor.of(pageRequest.mode());
        return executor.cursor(query, pageRequest, this);
    }

    public long count(String var1);

    @Override
    public void close();
}

