/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.semistructured;

import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.jnosql.communication.semistructured.CommunicationEntity;
import org.eclipse.jnosql.communication.semistructured.CommunicationObserverParser;
import org.eclipse.jnosql.communication.semistructured.CommunicationPreparedStatement;
import org.eclipse.jnosql.communication.semistructured.DatabaseManager;
import org.eclipse.jnosql.communication.semistructured.DeleteQueryParser;
import org.eclipse.jnosql.communication.semistructured.QueryType;
import org.eclipse.jnosql.communication.semistructured.SelectQueryParser;
import org.eclipse.jnosql.communication.semistructured.UpdateQueryParser;

public final class QueryParser {
    private final SelectQueryParser select = new SelectQueryParser();
    private final DeleteQueryParser delete = new DeleteQueryParser();
    private final UpdateQueryParser update = new UpdateQueryParser();

    public Stream<CommunicationEntity> query(String query, String entity, DatabaseManager manager, CommunicationObserverParser observer) {
        this.validation(query, manager, observer);
        QueryType command = QueryType.parse(query);
        return switch (command) {
            case QueryType.DELETE -> this.delete.query(query, manager, observer);
            case QueryType.UPDATE -> this.update.query(query, manager, observer);
            default -> this.select.query(query, entity, manager, observer);
        };
    }

    public CommunicationPreparedStatement prepare(String query, String entity, DatabaseManager manager, CommunicationObserverParser observer) {
        this.validation(query, manager, observer);
        QueryType command = QueryType.parse(query);
        return switch (command) {
            case QueryType.DELETE -> this.delete.prepare(query, manager, observer);
            case QueryType.UPDATE -> this.update.prepare(query, manager, observer);
            default -> this.select.prepare(query, entity, manager, observer);
        };
    }

    private void validation(String query, DatabaseManager manager, CommunicationObserverParser observer) {
        Objects.requireNonNull(query, "query is required");
        Objects.requireNonNull(manager, "manager is required");
        Objects.requireNonNull(observer, "manager is observer");
    }
}

