/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.semistructured;

import jakarta.data.Direction;
import jakarta.data.Sort;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jnosql.communication.Params;
import org.eclipse.jnosql.communication.QueryException;
import org.eclipse.jnosql.communication.query.data.SelectProvider;
import org.eclipse.jnosql.communication.semistructured.CommunicationEntity;
import org.eclipse.jnosql.communication.semistructured.CommunicationObserverParser;
import org.eclipse.jnosql.communication.semistructured.CommunicationPreparedStatement;
import org.eclipse.jnosql.communication.semistructured.Conditions;
import org.eclipse.jnosql.communication.semistructured.CriteriaCondition;
import org.eclipse.jnosql.communication.semistructured.DatabaseManager;
import org.eclipse.jnosql.communication.semistructured.DefaultSelectQuery;
import org.eclipse.jnosql.communication.semistructured.QueryParams;
import org.eclipse.jnosql.communication.semistructured.SelectQuery;

public final class SelectQueryParser
implements BiFunction<org.eclipse.jnosql.communication.query.SelectQuery, CommunicationObserverParser, QueryParams> {
    Stream<CommunicationEntity> query(String query, String entity, DatabaseManager manager, CommunicationObserverParser observer) {
        SelectQuery selectQuery = this.query(query, entity, observer);
        return manager.select(selectQuery);
    }

    CommunicationPreparedStatement prepare(String query, String entity, DatabaseManager manager, CommunicationObserverParser observer) {
        Params params = Params.newParams();
        SelectProvider converter = new SelectProvider();
        org.eclipse.jnosql.communication.query.SelectQuery selectQuery = converter.apply(query, entity);
        SelectQuery prepareQuery = this.query(params, selectQuery, observer);
        return CommunicationPreparedStatement.select(prepareQuery, params, query, manager);
    }

    @Override
    public QueryParams apply(org.eclipse.jnosql.communication.query.SelectQuery selectQuery, CommunicationObserverParser observer) {
        Objects.requireNonNull(selectQuery, "selectQuery is required");
        Objects.requireNonNull(observer, "observer is required");
        Params params = Params.newParams();
        SelectQuery columnQuery = this.query(params, selectQuery, observer);
        return new QueryParams(columnQuery, params);
    }

    private SelectQuery query(String query, String entity, CommunicationObserverParser observer) {
        SelectProvider converter = new SelectProvider();
        org.eclipse.jnosql.communication.query.SelectQuery selectQuery = converter.apply(query, entity);
        String entityName = observer.fireEntity(selectQuery.entity());
        long limit = selectQuery.limit();
        long skip = selectQuery.skip();
        List<String> columns = selectQuery.fields().stream().map(f -> observer.fireSelectField(entityName, (String)f)).toList();
        List<Sort<?>> sorts = selectQuery.orderBy().stream().map(s -> this.toSort((Sort<?>)s, observer, entityName)).collect(Collectors.toList());
        Params params = Params.newParams();
        CriteriaCondition condition = selectQuery.where().map(c -> Conditions.getCondition(c, params, observer, entityName)).orElse(null);
        if (params.isNotEmpty()) {
            throw new QueryException("To run a query with a parameter use a PrepareStatement instead.");
        }
        boolean count = selectQuery.isCount();
        return new DefaultSelectQuery(limit, skip, entityName, columns, sorts, condition, count);
    }

    private SelectQuery query(Params params, org.eclipse.jnosql.communication.query.SelectQuery selectQuery, CommunicationObserverParser observer) {
        String entity = observer.fireEntity(selectQuery.entity());
        long limit = selectQuery.limit();
        long skip = selectQuery.skip();
        List<String> columns = selectQuery.fields().stream().map(f -> observer.fireSelectField(entity, (String)f)).toList();
        List<Sort<?>> sorts = selectQuery.orderBy().stream().map(s -> this.toSort((Sort<?>)s, observer, entity)).collect(Collectors.toList());
        CriteriaCondition condition = selectQuery.where().map(c -> Conditions.getCondition(c, params, observer, entity)).orElse(null);
        boolean count = selectQuery.isCount();
        return new DefaultSelectQuery(limit, skip, entity, columns, sorts, condition, count);
    }

    private Sort<?> toSort(Sort<?> sort, CommunicationObserverParser observer, String entity) {
        return Sort.of((String)observer.fireSortProperty(entity, sort.property()), (Direction)(sort.isAscending() ? Direction.ASC : Direction.DESC), (boolean)false);
    }
}

