/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.redis.keyvalue;

import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.eclipse.jnosql.communication.redis.keyvalue.Counter;
import redis.clients.jedis.Jedis;

class DefaultCounter
implements Counter {
    private static final Predicate<String> IS_EMPTY = String::isEmpty;
    private static final Predicate<String> IS_NOT_EMPTY = IS_EMPTY.negate();
    private final String key;
    private Jedis jedis;

    DefaultCounter(String key, Jedis jedis) {
        this.key = key;
        this.jedis = jedis;
    }

    @Override
    public Number get() {
        return Optional.ofNullable(this.jedis.get(this.key)).filter(IS_NOT_EMPTY).map(Double::valueOf).orElse(0.0);
    }

    @Override
    public Number increment() {
        return this.increment(1);
    }

    @Override
    public Number increment(Number value) throws NullPointerException {
        Objects.requireNonNull(value, "value is required");
        return this.jedis.incrByFloat(this.key, value.doubleValue());
    }

    @Override
    public Number decrement() {
        return this.increment(-1);
    }

    @Override
    public Number decrement(Number value) {
        Objects.requireNonNull(value, "value is required");
        return this.jedis.incrByFloat(this.key, -value.doubleValue());
    }

    @Override
    public void delete() {
        this.jedis.del(this.key);
    }

    @Override
    public void expire(Duration ttl) throws NullPointerException {
        Objects.requireNonNull(ttl, "ttl is required");
        this.jedis.expire(this.key, (long)((int)ttl.getSeconds()));
    }

    @Override
    public void persist() {
        this.jedis.persist(this.key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultCounter)) {
            return false;
        }
        DefaultCounter that = (DefaultCounter)o;
        return Objects.equals(this.key, that.key);
    }

    public int hashCode() {
        return Objects.hashCode(this.key);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Counter{");
        sb.append("key='").append(this.key).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

