/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.redis.keyvalue;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import javax.json.bind.Jsonb;
import org.eclipse.jnosql.communication.driver.JsonbSupplier;
import org.eclipse.jnosql.communication.redis.keyvalue.Counter;
import org.eclipse.jnosql.communication.redis.keyvalue.DefaultCounter;
import org.eclipse.jnosql.communication.redis.keyvalue.DefaultSortedSet;
import org.eclipse.jnosql.communication.redis.keyvalue.RedisBucketManager;
import org.eclipse.jnosql.communication.redis.keyvalue.RedisBucketManagerFactory;
import org.eclipse.jnosql.communication.redis.keyvalue.RedisList;
import org.eclipse.jnosql.communication.redis.keyvalue.RedisMap;
import org.eclipse.jnosql.communication.redis.keyvalue.RedisQueue;
import org.eclipse.jnosql.communication.redis.keyvalue.RedisSet;
import org.eclipse.jnosql.communication.redis.keyvalue.SortedSet;
import redis.clients.jedis.JedisPool;

class DefaultRedisBucketManagerFactory
implements RedisBucketManagerFactory {
    private static final Jsonb JSON = (Jsonb)JsonbSupplier.getInstance().get();
    private final JedisPool jedisPool;

    DefaultRedisBucketManagerFactory(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
    }

    public RedisBucketManager apply(String bucketName) {
        Objects.requireNonNull(bucketName, "bucket name is required");
        return new RedisBucketManager(bucketName, JSON, this.jedisPool.getResource());
    }

    public <T> List<T> getList(String bucketName, Class<T> clazz) {
        Objects.requireNonNull(bucketName, "bucket name is required");
        Objects.requireNonNull(clazz, "Class type is required");
        return new RedisList<T>(this.jedisPool.getResource(), clazz, bucketName);
    }

    public <T> Set<T> getSet(String bucketName, Class<T> clazz) {
        Objects.requireNonNull(bucketName, "bucket name is required");
        Objects.requireNonNull(clazz, "Class type is required");
        return new RedisSet<T>(this.jedisPool.getResource(), clazz, bucketName);
    }

    public <T> Queue<T> getQueue(String bucketName, Class<T> clazz) {
        Objects.requireNonNull(bucketName, "bucket name is required");
        Objects.requireNonNull(clazz, "Class type is required");
        return new RedisQueue<T>(this.jedisPool.getResource(), clazz, bucketName);
    }

    public <K, V> Map<K, V> getMap(String bucketName, Class<K> keyValue, Class<V> valueValue) {
        Objects.requireNonNull(bucketName, "bucket name is required");
        Objects.requireNonNull(valueValue, "Class type is required");
        return new RedisMap<K, V>(this.jedisPool.getResource(), keyValue, valueValue, bucketName);
    }

    @Override
    public SortedSet getSortedSet(String key) throws NullPointerException {
        Objects.requireNonNull(key, "key is required");
        return new DefaultSortedSet(this.jedisPool.getResource(), key);
    }

    @Override
    public Counter getCounter(String key) throws NullPointerException {
        Objects.requireNonNull(key, "key is required");
        return new DefaultCounter(key, this.jedisPool.getResource());
    }

    public void close() {
        this.jedisPool.close();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RedisBucketManagerFactory{");
        sb.append("jedisPool=").append(this.jedisPool);
        sb.append('}');
        return sb.toString();
    }
}

